import enum

class TutorialTipGameState(enum.Int):
    GAMESTATE_NONE = 0
    LIVE_MODE = 270579719
    BUILD_BUY = 2919482169
    CAS = 983016380
    NEIGHBORHOOD_VIEW = 3640749201
    GALLERY = 1
    TRAVEL = 238138433


class TutorialTipUiElement(enum.Int):
    UI_INVALID = 0
    GLOBAL_ESCAPE_MENU = 1
    GLOBAL_ESCAPE_MENU_BUTTON = 2
    GLOBAL_HELP_BUTTON = 3
    GLOBAL_TRANSITION_SCREEN = 4
    GLOBAL_GENERIC = 5
    CAS_PERSONALITYPANEL = 100
    CAS_ASPIRATIONS = 101
    CAS_TRAITS = 102
    CAS_SIM_HEAD = 103
    CAS_SIM_BODY = 104
    CAS_OUTFIT_BUTTON = 105
    CAS_RELATIONSHIP_BUTTON = 106
    CAS_RANDOM_BUTTON = 107
    CAS_GENETICS_BUTTON = 108
    CAS_TATTOOS_BUTTON = 109
    CAS_SKIN_COLOR_MENU = 110
    CAS_GALLERY_SAVE_BUTTON = 111
    CAS_FEATURED_LOOKS_BUTTON = 112
    CAS_DETAILED_EDIT_BUTTON = 113
    CAS_PLUMBOB_BUTTON = 114
    CAS_NAME_PANEL = 115
    CAS_PRIMARY_ASPIRATION_BUTTON = 116
    CAS_ASPIRATION_GROUP_BUTTON = 117
    CAS_ASPIRATION_TRACK_BUTTON = 118
    CAS_TRAIT_GRID_BUTTON = 119
    CAS_BONUS_TRAIT_ICON = 120
    CAS_TRAIT_CATEGORY_BUTTON = 121
    CAS_OUTFIT_TYPE_BUTTON = 122
    CAS_MENU_BODY_BUTTON = 123
    CAS_MENU_FACES_BUTTON = 124
    CAS_MULTIPLE_SIMS = 125
    CAS_SKIN_DETAILS_BUTTON = 126
    CAS_GALLERY_BUTTON = 127
    CAS_GALLERY_RANDOMIZE_BUTTON = 128
    CAS_ADD_SIM_BUTTON = 129
    CAS_NAVIGATION_PLAY = 130
    CAS_NAVIGATION_CANCEL = 131
    CAS_STORIES = 132
    CAS_PREFERENCE_MOLECULE = 133
    CAS_TURNON_TURNOFF_TAB = 134
    CAS_SIM_CUSTOMIZATION_OPTIONS_BUTTON = 135
    CAS_REL_EXPECTATIONS_TAB = 136
    CAS_TATTOO_TO_PAINT_MODE_BUTTON = 137
    CAS_TATTOO_LAYERS = 138
    CAS_PAINT_BRUSH_SELECT = 139
    CAS_PAINT_COLOR_WHEEL = 140
    CAS_PAINT_EXIT = 141
    CAS_PAINT_PANEL = 142
    CAS_CLOTHING_PANEL = 143
    CAS_TATTOO_PANEL = 144
    CAS_GP_MENU_CYCLE = 150
    CAS_GP_HELP_CONTROL_LAYOUT = 151
    CAS_GP_BODY_MANIPULATION = 152
    NHV_SET_HOME = 200
    NHV_WORLD_SELECT = 201
    NHV_CURRENT_LOT = 202
    NHV_OCCUPANTS = 203
    NHV_PLAY_BUTTON = 204
    NHV_MORE_BUTTON = 205
    NHV_BUILD_BUTTON = 206
    NHV_EVICT_BUTTON = 207
    NHV_MOVE_HOUSEHOLD_BUTTON = 208
    NHV_CHANGE_LOT_TYPE_BUTTON = 209
    NHV_EMPTY_LOT = 210
    NHV_MOVE_NEW_HOUSEHOLD_BUTTON = 211
    NHV_OASIS_SPRINGS_MAP = 212
    NHV_WILLOW_CREEK_SELECT = 213
    NHV_HOUSEHOLD_MANAGEMENT = 214
    NHV_EMPTY_LOT_OASIS = 215
    NHV_STARTER_WILLOW = 216
    NHV_EMPTY_LOT_MOVE_IN = 217
    NHV_CONFIRM_BUTTON = 218
    NHV_FTUE_TRAVEL_LOT = 219
    NHV_MOVE_IN_OPTION_BUTTON = 220
    NHV_STARTER_MAP = 221
    NHV_EMPTY_MAP = 222
    NHV_WORLD_SELECT_BUTTON = 223
    NHV_SEASON_SELECT = 224
    NHV_MOVE_IN_CANCEL = 225
    NHV_SAN_MYSHUNO_SELECT = 226
    NHV_MULTI_UNIT_WORLD = 227
    NHV_MULTI_UNIT_WORLD_TENANT = 228
    LIVE_WALL_BUTTON = 300
    LIVE_SIM_SELECTOR = 301
    LIVE_CURRENT_SIM_PORTRAIT = 302
    LIVE_TIME_CONTROLS = 303
    LIVE_INTERACTION_QUEUE = 304
    LIVE_BUILD_BUTTON = 305
    LIVE_EMOTION = 306
    LIVE_BUFF = 307
    LIVE_MOTIVE_PANEL_BUTTON = 308
    LIVE_SKILL_PANEL_BUTTON = 310
    LIVE_SIMOLEON_WALLET = 311
    LIVE_CAREER_PANEL_BUTTON = 312
    LIVE_GET_JOB_BUTTON = 313
    LIVE_CAREER_GOALS = 314
    LIVE_EVENTS_UI = 315
    LIVE_EVENT_GOALS_UI = 316
    LIVE_REL_INSPECTOR = 317
    LIVE_SIM_IN_REL_INSPECTOR = 318
    LIVE_RELATIONSHIP_PANEL_BUTTON = 319
    LIVE_ASPIRATION_PANEL_BUTTON = 320
    LIVE_ASPIRATION_ICON = 321
    LIVE_SATISFACTION_STORE_BUTTON = 322
    LIVE_CHANGE_ASPIRATION_BUTTON = 323
    LIVE_SUMMARY_PANEL_BUTTON = 324
    LIVE_TRAIT_IN_PANEL = 325
    LIVE_INVENTORY_PANEL_BUTTON = 326
    LIVE_ITEM_IN_PANEL = 327
    LIVE_SKILL_LIST = 328
    LIVE_FLOOR_BUTTON = 329
    LIVE_CAREER_ADVANCEMENT = 330
    LIVE_PHONE_BUTTON = 331
    LIVE_NOTIFICATION_WALL_BUTTON = 352
    LIVE_MANAGE_WORLDS_BUTTON = 353
    LIVE_CALENDAR_BUTTON = 354
    LIVE_CLUB_PANEL_BUTTON = 355
    LIVE_VENUE_PANEL_BUTTON = 356
    LIVE_CAMERA_ADVANCED_BUTTON = 357
    LIVE_HOUSEHOLD_SIM_1 = 358
    LIVE_HOUSEHOLD_SIM_2 = 359
    LIVE_HOUSEHOLD_SIM_1_GO_HOME = 360
    LIVE_HOUSEHOLD_SIM_2_GO_HOME = 361
    LIVE_SIM_PICKER_UI = 362
    LIVE_TIME_SPEED3_CONTROL = 363
    LIVE_HUB_WHIM = 364
    LIVE_CLUB_MANAGER = 332
    LIVE_CLUB_MANAGER_LIST = 333
    LIVE_CLUB_PANEL = 334
    LIVE_CLUB_PANEL_CLUB_PICKER = 335
    LIVE_CLUB_PANEL_CONDUCT_RULES = 336
    LIVE_CLUB_PANEL_REWARDS = 337
    LIVE_CLUB_PANEL_START_GATHERING = 338
    LIVE_CLUB_DETAILS_PANEL = 339
    LIVE_CLUB_DETAILS_IDENTITY = 340
    LIVE_CLUB_DETAILS_ADMISSION_RULES = 341
    LIVE_CLUB_DETAILS_CLUB_MEMBERS = 342
    LIVE_CLUB_DETAILS_CONDUCT_RULES = 343
    LIVE_CLUB_ADMISSIONS_PANEL = 344
    LIVE_CLUB_ADMISSIONS_CREATION = 345
    LIVE_CLUB_ADMISSIONS_DETAILS = 346
    LIVE_CLUB_ADMISSIONS_QUALIFIERS = 347
    LIVE_CLUB_CONDUCT_PANEL = 348
    LIVE_CLUB_CONDUCT_ENCOURAGED = 349
    LIVE_CLUB_CONDUCT_ACTION = 350
    LIVE_CLUB_MANAGER_CREATE_CLUB = 351
    LIVE_SBC_PRESETS = 365
    LIVE_SBC_ENTRY_FEE = 366
    LIVE_SBC_ATTENDEE_CATEGORY = 367
    LIVE_SBC_ATTENDEE_REQUIRED_CHECKBOX = 368
    LIVE_SBC_ATTENDEE_SUPERVISED_CHECKBOX = 369
    LIVE_SBE_MANAGEMENT_PANEL = 370
    LIVE_SBE_TASKS_PANEL = 371
    LIVE_SBC_PANEL_TOP = 372
    BB_BUILD_SORT = 400
    BB_OBJECTS_BY_ROOM = 401
    BB_OBJECTS_BY_FUNCTION = 402
    BB_SEARCH_BAR = 403
    BB_FAMILY_INVENTORY = 404
    BB_CAMERA = 405
    BB_EYEDROPPER = 406
    BB_SLEDGEHAMMER = 407
    BB_DESIGN_TOOL = 408
    BB_UNDO_REDO = 409
    BB_SHARE_LOT = 410
    BB_GALLERY_BUTTON = 411
    BB_MAGALOG_CATEGORY = 412
    BB_MAGALOG_ITEM = 413
    BB_EMPTY_ROOM = 414
    BB_NAVIGATION_HOUSE = 415
    BB_STAIRS = 416
    BB_DOOR = 417
    BB_PRODUCT_CATALOG_ITEM = 418
    BB_CAMERA_FLOOR = 419
    BB_MAGALOG_BUTTON = 420
    BB_BEDBATH_DROPDOWN = 421
    BB_BULLDOZE = 422
    BB_LOTNAME = 423
    BB_FOUNDATION_BUTTON = 424
    BB_MAGALOG_FURNISHED_ROOMS = 425
    BB_LOT_INFO = 426
    BB_PRODUCT_CATALOG_STAIRS = 427
    BB_POOL_TOOL = 428
    BB_POOL_OBJECTS = 429
    BB_TIME_CONTROL = 431
    BB_VENUE_CONFIG_PANEL = 432
    BB_UNIT_VISUALIZATION = 433
    BB_SMALL_BUSINESS_PANEL = 434
    BB_SMALL_BUSINESS_PANEL_BUTTON = 435
    BB_SMALL_BUSINESS_PANEL_WARNING = 436
    BB_GP_NOT_GALLERY_UI = 430
    GAL_GALLERY_UI = 500
    GAL_HOME_TAB = 501
    GAL_FEED_SECTION = 502
    GAL_HASHTAG_SECTION = 503
    GAL_SPOTLIGHT_SECTION = 504
    GAL_COMMUNITY_TAB = 505
    GAL_LIBRARY_TAB = 506
    GAL_FILTER_HEADER = 507
    GAL_FILTERS_PANEL = 508
    GAL_SEARCH_WIDGET = 509
    GAL_THUMBNAILS_WIDGET = 510
    GAL_INFO_PANEL = 511
    GAL_COMMENTS = 512
    GAL_SAVE_BUTTON = 513
    GAL_APPLY_BUTTON = 514
    GAL_PLAYER_PROFILE = 515
    MTX_PACK_BROWSER = 600
    MTX_PACK_BROWSER_NCAS = 601
    CONTROL_PANEL_CAMERA = 700
    CONTROL_PANEL_GUIDANCE = 701
    HVP_VENUE_PANEL = 800
    HVP_RENTAL_UNIT_PANEL = 801
    HVP_RENTAL_UNIT_PURCHASE = 802
    HVP_SMALL_BUSINESS_PANEL = 803
    PMI_FILL_VACANCY = 900
    PMI_AGREEMENT_SETTINGS = 901
    PMI_AGREEMENT_RATING = 902
    PMI_AGREEMENT_RULES = 903
    PMI_AGREEMENT_NEXT = 904
    PMI_APPLICATION_UNIT = 905
    PMI_APPLICATION_TENANT = 906
    PMI_APPLICATION_CONFIRM = 907


class TutorialTipGroupRequirementType(enum.Int):
    ANY = 0
    ALL = 1


class TutorialTipDisplayOption(enum.Int):
    STANDARD = 0
    GAME_MODE = 1
    ARROW_INDICATOR = 2
    CIRCLE_OVER_INDICATOR = 3


class TutorialTipActorOption(enum.Int):
    ACTIVE_SIM = 0
    PLAYER_SIM = 1
    HOUSEMATE_SIM = 2


class TutorialTipTestSpecificityOption(enum.Int):
    UNSPECIFIED = 0
    ACTIVE_SIM = 1
    PLAYER_SIM = 2
    HOUSEMATE_SIM = 3


class TutorialMode(enum.Int):
    DISABLED = 0
    STANDARD = 1
    FTUE = 2


class TutorialTipSubtitleDisplayLocation(enum.Int):
    TOP = 0
    BOTTOM = 1

