from sims4.tuning.tunable import HasTunableSingletonFactory, AutoFactoryInit, TunableMapping, TunableReference, TunableSet
from snippets import define_snippet
import services
import sims4.resources

class TempleRoomData(HasTunableSingletonFactory, AutoFactoryInit):
    FACTORY_TUNABLES = {'gate': TunableSet(description='\n            A set of states in which the gate in this room can potentially\n            start.\n            ', tunable=TunableReference(description='\n                A potential starting state for the gate in this room.\n                ', manager=services.get_instance_manager(sims4.resources.Types.OBJECT_STATE), class_restrictions=('ObjectStateValue',))), 'traps': TunableMapping(description='\n            A mapping of trap objects to the interactions that can be used in\n            the pool potential of "trigger" interaction. A trap object will be\n            chosen at random from this mapping and placed at each placeholder\n            trap in this room. Once all trap objects have been chosen and placed\n            for a room, all of the mapped interactions will be collected and one\n            random interaction will be chosen as the "trigger" interaction.\n            ', key_name='Trap', key_type=TunableReference(description='\n                A reference to the trap object.\n                ', manager=services.definition_manager()), value_name='Potential Trigger Interactions', value_type=TunableSet(description='\n                A set of interactions that, if successfully completed on the\n                chosen trap object, will trigger the loot for the gate in this\n                room.\n                ', tunable=TunableReference(description='\n                    One of the potential trigger interactions. This interaction\n                    also needs to be tuned on the object chosen for this trap.\n                    ', manager=services.get_instance_manager(sims4.resources.Types.INTERACTION), class_restrictions=('SuperInteraction',))))}

(TunableTempleRoomData, _) = define_snippet('TempleRoomData', TempleRoomData.TunableFactory())
