from buffs.tunable import TunableBuffReference
from sims.outfits.outfit_enums import BodyType
from sims4.localization import TunableLocalizedStringFactory
from sims4.tuning.dynamic_enum import DynamicEnum
from sims4.tuning.tunable import Tunable, TunableTuple, OptionalTunable, TunableEnumEntry, TunableMapping, HasTunableSingletonFactory, AutoFactoryInit
from tag import TunableTags
from ui.ui_dialog_notification import UiDialogNotification

class TattooQuality(DynamicEnum):
    NONE = 0


class TattooSentimentType(DynamicEnum):
    NONE = 0


class CheckTattooDataNotification(HasTunableSingletonFactory, AutoFactoryInit):
    FACTORY_TUNABLES = {'notification': UiDialogNotification.TunableFactory(description='\n            The notification displayed.\n            ', locked_args={'text': None}), 'non_sentimental': TunableLocalizedStringFactory(description='\n            TNS entries for non sentimental tattoos: {0.String}: {1.String} \n            e.g. Chest: Poor Quality\n            '), 'sentimental_entry': TunableLocalizedStringFactory(description='\n            TNS entries for sentimental tattoos: {0.String}: {1.String} dedicated to {2.SimName} ({3.String))\n            e.g. Stomach: Normal Quality, dedicated to Eliza Pancakes (lover) \n            '), 'sentimental_no_sim_entry': TunableLocalizedStringFactory(description='\n            TNS entries for sentimental tattoos when sim has been wiped: {0.String}: {1.String} dedicated to and unknown sim \n            Stomach: Normal Quality, dedicated to someone unknown (lover)\n            '), 'quality_strings': TunableMapping(description="\n            String to show according to the tattoo's quality\n            Key: tattoo_quality\n            Value: string\n            ", key_name='tattoo_quality', value_name='string', key_type=TunableEnumEntry(description='\n                Tattoo Quality\n                ', tunable_type=TattooQuality, default=TattooQuality.NONE), value_type=TunableLocalizedStringFactory()), 'sentiment_type_strings': TunableMapping(description="\n            String to show according to the tattoo's sentimental type\n            Key: TattooSentimentType\n            Value: string\n            ", key_name='tattoo_sentiment_type', value_name='string', key_type=TunableEnumEntry(description='\n                Tattoo Sentiment Type\n                ', tunable_type=TattooSentimentType, default=TattooSentimentType.NONE), value_type=TunableLocalizedStringFactory()), 'body_type_strings': TunableMapping(description='\n            String to show according to the body type\n            Key: BodyType\n            Value: string\n            ', key_name='body_type', value_name='string', key_type=TunableEnumEntry(description='\n                Body Type\n                ', tunable_type=BodyType, default=BodyType.NONE), value_type=TunableLocalizedStringFactory())}


class TattooTuning:
    TATTOO_MAX_LAYERS = Tunable(description='\n        Number of maximum layers \n        ', tunable_type=int, default=5)
    TATTOO_BODY_TYPES = [BodyType.TATTOO_ARM_LOWER_LEFT, BodyType.TATTOO_ARM_UPPER_LEFT, BodyType.TATTOO_ARM_LOWER_RIGHT, BodyType.TATTOO_ARM_UPPER_RIGHT, BodyType.TATTOO_LEG_LEFT, BodyType.TATTOO_LEG_RIGHT, BodyType.TATTOO_TORSO_BACK_LOWER, BodyType.TATTOO_TORSO_BACK_UPPER, BodyType.TATTOO_TORSO_FRONT_LOWER, BodyType.TATTOO_TORSO_FRONT_UPPER, BodyType.TATTOO_HEAD]
    TATTOOING_PROCESS_BUFFS = OptionalTunable(description='\n        If set, buffs that will be given while custom tattooing to inform the sim if tattoos has been applied or not when\n        coming back from cas \n        ', tunable=TunableTuple(waiting_for_result=TunableBuffReference(description='\n                This will be used to tell the sim we are waiting to return from CAS\n                ', pack_safe=True), finished=TunableBuffReference(description="\n                This will be used to tell the sim we returned from CAS and there's been modifications\n                ", pack_safe=True), cancelled=TunableBuffReference(description="\n                This will be used to tell the sim we returned from CAS and there's been no modifications\n                ", pack_safe=True)))
    TATTOO_DEFAULT_QUALITY = TunableEnumEntry(description='\n        Default tattoo quality\n        ', tunable_type=TattooQuality, default=TattooQuality.NONE)
    TATTOO_DEFAULT_SENTIMENTAL_TYPE_VALUE = TunableEnumEntry(description='\n        Default tattoo sentimental type\n        ', tunable_type=TattooSentimentType, default=TattooSentimentType.NONE)
    CHECK_TATTOO_NOTIFICATION = CheckTattooDataNotification.TunableFactory(description='\n        Check tattoo in mirror TNS configuration\n        ')
    IGNORE_TAGS = TunableTags(description="\n        CASParts with this tags won't be treated as tattoos\n        e.g. Medical wearables use the tattoos slots but are not tattoos\n        ")

