import services
from interactions.utils.tunable_icon import TunableIcon
from sims4.localization import TunableLocalizedString
from sims4.resources import Types
from sims4.tuning.instances import HashedTunedInstanceMetaclass
from sims4.tuning.tunable_base import ExportModes

class StoryProgressionRuleDisplayInfo(metaclass=HashedTunedInstanceMetaclass, manager=services.get_instance_manager(Types.USER_INTERFACE_INFO)):
    INSTANCE_TUNABLES = {'rule_name': TunableLocalizedString(description="\n            String to be displayed as this rule's name.\n            ", export_modes=ExportModes.ClientBinary), 'rule_description': TunableLocalizedString(description="\n            String to be displayed as this rule's description.\n            ", export_modes=ExportModes.ClientBinary), 'rule_icon': TunableIcon(description='\n            Icon to be displayed to represent this rule.\n            ', export_modes=ExportModes.ClientBinary)}

