import services
import sims4.log
from autonomy.autonomy_modifier import TunableOffLotAutonomy
from bucks.bucks_enums import BucksType
from buffs.tunable import TunableBuffReference
from business.business_enums import BusinessEmployeeType, SmallBusinessSalary
from clubs.club_tuning import TunableClubRuleSnippet
from event_testing.tests import TunableTestSet
from interactions.utils.tunable_icon import TunableIconAllPacks
from sims.sim_info_types import Age, Species
from sims4.localization import TunableLocalizedString, TunableLocalizedStringFactory
from sims4.resources import Types
from sims4.tuning.tunable import Tunable, TunableRange, TunableSet, TunableList, TunableMapping, TunableReference, TunableEnumEntry, TunableEnumSet, TunableSimMinute, TunablePackSafeReference, TunableTuple, TunablePercent, OptionalTunable
from sims4.tuning.tunable_base import GroupNames, ExportModes
from tag import Tag, TunableTag, TunableTags
from ui.ui_dialog import UiDialogOkCancel
from ui.ui_dialog_notification import UiDialogNotification, TunableUiDialogNotificationSnippet
from ui.ui_dialog_picker import UiSkillsSimPicker
MAX_BUSINESS_RULES = 5
MAX_MEMBERSHIP_CRITERIA = 5

class BusinessPreset(metaclass=sims4.tuning.instances.HashedTunedInstanceMetaclass, manager=services.get_instance_manager(sims4.resources.Types.SNIPPET)):
    INSTANCE_TUNABLES = {'name': sims4.localization.TunableLocalizedStringFactory(description='\n            Display name for this preset\n            ', export_modes=ExportModes.ClientBinary), 'rule_set': TunableSet(description='\n            Rules for this preset.\n            ', tunable=TunablePackSafeReference(description='\n                The ClubInteractionGroup that this rule applies to.\n                ', manager=services.get_instance_manager(sims4.resources.Types.CLUB_INTERACTION_GROUP)), maxlength=MAX_BUSINESS_RULES, export_modes=ExportModes.ClientBinary)}


class SmallBusinessTunables:
    BUSINESS_ENCOURAGEMENT_AD_DATA = Tunable(description='\n        The default value that business rule encouragement static commodities will\n        advertise at.\n        ', tunable_type=int, default=64)
    BUSINESS_ENCOURAGEMENT_AD_DATA_ACTIVE_SIM = Tunable(description='\n        The default value that business rule encouragement static commodities will\n        advertise at for player controlled sims.\n        ', tunable_type=int, default=64)
    BUSINESS_ENCOURAGEMENT_MULTIPLIER = TunableRange(description="\n        The multiplier to apply to an interaction's final autonomy score in the\n        case that a business rule encourages that action. This tunable has the\n        responsibility of making sure Sims will not run encouraged interactions\n        100% of the time with no chance of normal things like solving motives,\n        even if those actions are not encouraged.\n        ", tunable_type=float, default=1.25, minimum=0)
    BUSINESS_ENCOURAGEMENT_SUBACTION_MULTIPLIER = TunableRange(description="\n        The multiplier to apply to a mixer interaction's final subaction\n        autonomy score in the case that it is encouraged by a business rule.\n        ", tunable_type=float, default=100, minimum=1)
    BUSINESS_AREA_MULTIPLIER = TunableRange(description="\n        The multiplier to apply to an interaction's final autonomy score for employees \n        and the owner if the object is found in small business areas while the \n        small business is open.\n        ", tunable_type=float, default=1.5, minimum=1)
    BUSINESS_AREA_TAGS = TunableList(description='\n        The tags used to identify objects that are located inside business areas of a\n        small business.\n        ', tunable=TunableEnumEntry(description='\n            Tags used to identify objects inside the small business areas.\n            ', tunable_type=Tag, default=Tag.INVALID, pack_safe=True))
    MINIMUM_CRITERIA_SKILL_LEVEL = Tunable(description='\n        Business rules and business membership criteria can specify specific skills\n        that Sims must have in order for those things to apply to them. This\n        tunable defines the minimum required skill level for those skills.\n        ', tunable_type=int, default=3)
    SMALL_BUSINESS_CUSTOMER_FILTER = TunablePackSafeReference(description='\n        A reference to a SimFilter that will be used to find customers.\n        A list of additional filterTerms will be passed in when this\n        is instanced depending on business admission criteria.\n        ', manager=services.get_instance_manager(sims4.resources.Types.SIM_FILTER), class_restrictions=('TunableSimFilter',))
    EMPLOYEE_TYPE = TunableEnumEntry(description='\n        The type of employee that small business employees will be hired as.\n        ', tunable_type=BusinessEmployeeType, default=BusinessEmployeeType.INVALID, invalid_enums=(BusinessEmployeeType.INVALID,))
    SMALL_BUSINESS_POTENTIAL_EMPLOYEE_FILTER = TunablePackSafeReference(description='\n        A reference to a SimFilter that will be used to find \n        potential employees based on relationship to the owner sim.\n        ', manager=services.get_instance_manager(sims4.resources.Types.SIM_FILTER), class_restrictions=('TunableSimFilter',))
    SMALL_BUSINESS_HIRE_EMPLOYEE_DIALOG = UiSkillsSimPicker.TunableFactory(description='\n        The picker dialog to show when hiring employees.\n        ', locked_args={'include_mood': False})
    SMALL_BUSINESS_HIRE_EMPLOYEE_CAP = TunableRange(description='\n        The maximum number of Sims allowed in the picker to hire employees\n        for the small business.\n        ', tunable_type=int, default=27, minimum=1)
    MIN_RELATIONSHIP_FOR_SMALL_BUSINESS_EMPLOYEE_HIRE = Tunable(description='\n        A minimum relationship value between business owner and the potential employee\n        for them to be available in the potential employee picker.\n        ', tunable_type=int, default=0)
    MIN_RELATIONSHIP_FOR_SMALL_BUSINESS_EMPLOYEE_HIRE_FAILED_TOOLTIP_TEXT = TunableLocalizedString(description="\n        Text to show as a tooltip when the sim can't be hired because the relationship check failed\n        ")
    EMPLOYEE_RELBIT = TunableReference(description='\n        Rel bit to apply between employee and employer.\n        ', manager=services.get_instance_manager(sims4.resources.Types.RELATIONSHIP_BIT), class_restrictions=('RelationshipBit',), pack_safe=True)
    BUSINESS_RULES_PRESETS = TunableList(description='\n        Predefined sets of rules for small businesses.\n        ', tunable=TunableReference(description='\n            A business preset.\n            ', manager=services.get_instance_manager(sims4.resources.Types.SNIPPET), class_restrictions=('BusinessPreset',), pack_safe=True), export_modes=ExportModes.ClientBinary)
    MIN_ATTENDANCE_CRITERIA_SCORE = Tunable(description='\n        Minimum filter result when testing target audience criteria.\n        ', tunable_type=float, default=0.1)
    ALWAYS_ACTIVE_RULES = TunableSet(description='\n        Rules that is always active for all businesses\n        ', tunable=TunableClubRuleSnippet(pack_safe=True))
    BUSINESS_RANK_HOURLY_BASELINES = TunableList(description='\n        List of amount baselines for each one of the Business Ranks, \n        to be used for to set the Hourly Fees for Attendance Sale system.\n        ', tunable=Tunable(tunable_type=int, default=0))
    BUSINESS_RANK_ENTRY_BASELINES = TunableList(description='\n        List of amount baselines for each one of the Business Ranks, \n        to be used for to set the Hourly Fees for Attendance Sale system.\n        ', tunable=Tunable(tunable_type=int, default=0))
    MARKUP_AND_SATISFACTION_MAPPING = TunableMapping(description='\n        Pairs of values that include the Markup multiplier \n        with their associated Customer Satisfaction multiplier\n        ', key_type=Tunable(description='\n            The markup multiplier.\n            ', tunable_type=float, default=1.0), key_name='markup_multiplier', value_type=Tunable(description='\n            The customer satisfaction multiplier which will be applied to a transaction done with the markup paired.\n            ', tunable_type=float, default=1.0), value_name='customer_satisfaction_multiplier')
    SMALL_BUSINESS_PERKS_BUCKS_TYPE = TunableEnumEntry(description='\n        A reference to the bucks type used for Fame Perks.\n        ', tunable_type=BucksType, default=BucksType.INVALID, pack_safe=True)
    SMALL_BUSINESS_RANK_RANKED_STATISTIC = TunableReference(description='\n        The statistic that represents the Small Business Rank.\n        ', manager=services.get_instance_manager(sims4.resources.Types.STATISTIC), pack_safe=True, class_restrictions=('RankedStatistic',), export_modes=ExportModes.ClientBinary)
    SMALL_BUSINESS_REPUTATION_RANKED_STATISTIC = TunableReference(description='\n        The statistic that represents the Small Business Reputation.\n        ', manager=services.get_instance_manager(sims4.resources.Types.STATISTIC), pack_safe=True, class_restrictions=('RankedStatistic',), export_modes=ExportModes.ClientBinary)
    SMALL_BUSINESS_VALUE_STATISTIC = TunableReference(description='\n        The statistic that represents the Small Business Value.\n        ', manager=services.get_instance_manager(sims4.resources.Types.STATISTIC), pack_safe=True)
    SMALL_BUSINESS_VISIT_ROLE_TAG = TunableEnumEntry(description='\n        A tag that identifies the business role that states that the sim is inside of the business, acting as a \n        customer (that has checked in, if a ticket machine is present).\n        The RoleState role_smallBusinessCustomer_BusinessVisit should have this tag present.\n        ', tunable_type=Tag, default=Tag.INVALID)
    BUSINESS_TAG = TunableEnumEntry(description='\n        Business tag to identify business traits.\n        ', tunable_type=Tag, default=Tag.INVALID)
    TICKET_MACHINE_TAG = TunableEnumEntry(description='\n        Tag to find the ticket machine on the lot.\n        ', tunable_type=Tag, default=Tag.INVALID, invalid_enums=(Tag.INVALID,), pack_safe=True)
    LIGHT_RETAIL_SURFACE_TAG = TunableEnumEntry(description='\n        Tag to find the Light Retail Surface on the lot.\n        ', tunable_type=Tag, default=Tag.INVALID, invalid_enums=(Tag.INVALID,), pack_safe=True)
    DEPENDENT_PLACEMENT_OBJECT_TAGS = TunableSet(description='\n        List of tags for each carried dependent type, defining objects they should\n        be placed nearby whenever possible.\n        ', tunable=TunableTuple(description='\n            Tags and dependent data.\n            ', age=TunableEnumEntry(description='\n                The dependent age.\n                ', tunable_type=Age, default=Age.CHILD), species=TunableEnumEntry(description='\n                The dependent species.\n                ', tunable_type=Species, default=Species.HUMAN), object_tags=TunableEnumSet(description='\n                The list of tags to match objects for this dependent type.\n                ', enum_type=Tag, enum_default=Tag.INVALID, invalid_enums=(Tag.INVALID,))))
    INOPERABLE_TICKET_MACHINE_TNS = UiDialogNotification.TunableFactory(description="\n        TNS that is displayed when the ticket machine can't operate (no power or burnt).\n        ")
    INACCESSIBLE_TICKET_MACHINE_TNS = UiDialogNotification.TunableFactory(description='\n        TNS that is displayed when there is no path possible to the ticket machine.\n        ')
    NO_CUSTOMERS_MATCHING_CRITERIA_TNS = UiDialogNotification.TunableFactory(description='\n        TNS that is displayed when there are no customers matching all required criteria in the save.\n        ')
    ALL_CUSTOMER_MATCHING_CRITERIA_ON_COOLDOWN_TNS = UiDialogNotification.TunableFactory(description="\n        TNS that is displayed when all customers matching all required criteria are on a cooldown ans can't attend.\n        ")
    NO_CUSTOMER_TNS_COOLDOWN = TunableSimMinute(description='\n        Amount of time until the no available customer TNS (either all customers on cooldown, \n        or no customers matching criteria) can be shown again.', default=120, minimum=0)
    REGISTER_BUSINESS_NOTIFICATION_TNS = TunableUiDialogNotificationSnippet(description='\n        The notification that shows up when the player registers the small business.\n        ')
    REGISTER_BUSINESS_NOTIFICATION_TNS_ON_INVALID_LOT = TunableUiDialogNotificationSnippet(description='\n        The notification that shows up when the player registers the small business on invalid lot.\n        ')
    NO_VALID_LOT_TNS = TunableUiDialogNotificationSnippet(description='\n        The notification that shows up when the small business has no valid lots assigned to it.\n        ')
    SELL_BUSINESS_NOTIFICATION_TNS = TunableUiDialogNotificationSnippet(description='\n        The notification that shows up when the player sells the small business.\n        ')
    HIRE_EMPLOYEE_NOTIFICATION = TunableUiDialogNotificationSnippet(description='\n        The notification that shows up when an employee is hired.\n        ', pack_safe=True)
    CHECK_IN_COMMODITIES = TunableList(description='\n        A list of static commodities that will checked when looking for ticket machines to check in.\n        ', tunable=TunableReference(description='\n            A static commodity that is solved for by autonomy to find the ticket machine. \n            ', manager=services.get_instance_manager(sims4.resources.Types.STATIC_COMMODITY), class_restrictions=('StaticCommodity',), pack_safe=True))
    OFF_LOT_AUTONOMY_RULE = TunableOffLotAutonomy(description='\n        The autonomy rule used when verifying if the ticket machine can be accessed by the customer.\n        ')
    SATISFACTION_WAITING_RATIO_FREQUENCY = TunableSimMinute(description='\n        Frequency between two compute of waiting ratio for satisfaction logic.\n        Does not run while performing interactions\n        ', default=60, minimum=1)
    SMALL_BUSINESS_ICONS = TunableSet(description='\n        A set of icons available for use with Small Businesses.\n        Consumed by UI when populating icon options in the Small Business Configurator.\n        ', tunable=TunableIconAllPacks(), export_modes=ExportModes.ClientBinary)
    SMALL_BUSINESS_OWNER_ON_DEATH_LOOT = TunablePackSafeReference(description='\n        Loot to apply when Small Business owner Sim dies.\n        ', manager=services.get_instance_manager(sims4.resources.Types.ACTION), class_restrictions=('LootActions',))
    SMALL_BUSINESS_EMPLOYEE_ON_FIRE_LOOT = TunablePackSafeReference(description='\n        Loot to apply when Small Business employee is fired.\n        ', manager=services.get_instance_manager(sims4.resources.Types.ACTION), class_restrictions=('LootActions',))
    SUMMARY_DIALOG_LIGHT_RETAIL_SALES_HEADER = TunableLocalizedString(description="\n        The header for the 'Light Retail Sales' line item.\n        ", tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_BUSINESS_OPENING_FEE_HEADER = TunableLocalizedString(description="\n        The header for the 'Business Opening Fee' line item.\n        ", tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_INTERACTION_SALES_HEADER = TunableLocalizedString(description="\n        The header for the 'Interaction Sales' line item. Should be something like 'Services'\n        ", tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_ATTENDANCE_FEES_HEADER = TunableLocalizedString(description="\n        The header for the 'Attendance Fees' line item. Should be something like 'Entrance Fees'\n        ", tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_ENTRY_FEES_TEXT = TunableLocalizedStringFactory(description="\n        The text in the 'Attendance Fees' line item if we're on Entry Fees mode.\n        ", tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_HOURLY_FEES_TEXT = TunableLocalizedStringFactory(description="\n        The text in the 'Attendance Fees' line item if we're on Hourly Fees mode.\n        ", tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_TIP_JAR_HEADER = TunableLocalizedString(description="\n        The header for the 'Tip Jar' line item.\n        ", tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_NO_TICKET_MACHINE_TOOLTIP = TunableLocalizedString(description="\n        The tooltip that we want to show in case there's no ticket machine on the lot.\n        ", tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_NO_LIGHT_RETAIL_TOOLTIP = TunableLocalizedString(description="\n        The tooltip that we want to show in case there's no light retail surfaces on the lot.\n        ", tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_ATTENDANCE_SALES_DISABLED_TOOLTIP = TunableLocalizedString(description='\n        The tooltip that we want to show in case the Attendance sales are disabled.\n        ', tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_LIGHT_RETAIL_SALES_DISABLED_TOOLTIP = TunableLocalizedString(description='\n        The tooltip that we want to show in case the Light Retail sales are disabled.\n        ', tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_BUCKS_GAINED_TEXT = TunableLocalizedStringFactory(description='\n        The text in the Net Profit line that indicates how much Business XP have we earned.\n        ', tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_CURRENCY_TEXT = TunableLocalizedStringFactory(description='\n        Text used to indicate an amount of money.\n        ', tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_AMOUNT_TEXT = TunableLocalizedStringFactory(description='\n        Text used to indicate an amount of times something has happened.\n        ', tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_NO_EMPLOYEES_TOOLTIP = TunableLocalizedString(description='\n        The tooltip that we want to show in case there are no Employees hired.\n        ', tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_CURRENCY_WITH_PERK_BOOST_TEXT = TunableLocalizedStringFactory(description='\n        The Text used to indicate an amount of money that has been boosted with specific perks.\n        ', tuning_group=GroupNames.UI)
    SUMMARY_DIALOG_PERK_BOOST_TOOLIP_TEXT = TunableLocalizedStringFactory(description='\n        The Text used to indicate which perks has been used to boost the number of customers.\n        ', tuning_group=GroupNames.UI)
    BUSINESS_EVENTS_INTERACTION = TunableReference(description='\n        The affordance to fire business events.\n        ', manager=services.get_instance_manager(Types.INTERACTION), pack_safe=True)
    BUSINESS_EVENTS_LOOT = TunablePackSafeReference(description='\n        Loot to schedule the business events.\n        ', manager=services.get_instance_manager(sims4.resources.Types.ACTION), class_restrictions=('LootActions',))
    BUSINESS_EVENTS_DRAMA_SCHEDULER = TunableReference(description='\n        The statistic that represents the Small Business Reputation.\n        ', manager=services.get_instance_manager(sims4.resources.Types.DRAMA_NODE), pack_safe=True)
    BUSINESS_EVENTS_COOLDOWN_BUFF = TunablePackSafeReference(description='\n        If a business event is fired, this buff is applied to Sim for week period \n        and the next event runs only after the buff expires\n        ', manager=services.get_instance_manager(Types.BUFF), allow_none=False)
    HOBBY_CLASS_CLOSE_BUSINESS_WARNING_DIALOG = UiDialogOkCancel.TunableFactory(description='\n        A dialog that is shown when a hobby class is going when trying to close the small business.\n        ')
    HOBBY_CLASS_SITUATION_TAG = TunableTag(description='\n        Tag which delineates which situations are fan situations.\n        ', filter_prefixes=('Situation',))
    SMALL_BUSINESS_CUSTOMER_REPUTATION_FILTER = TunableMapping(description='\n        Define the custom sim filter for the customers that will spawn certain sims depending on the Small Business\n        Reputation \n        ', key_type=int, value_type=TunableTuple(description='\n            An additional filter list that will increase the probability that a customer with certain traits will \n            spawn depending on the small business reputation.\n            ', customer_test=TunableTestSet(description='\n                A test for the customers that will spawn more often.\n                '), probability=TunablePercent(description='\n                The probability that the customers that pass the test will spawn more often.\n                ', default=30)), tuple_name='CustomerReputationFilterMapping')
    PERK_SETTINGS = TunableTuple(description='\n        Configuration for all the tunings available in Small Business Perks.\n        ', tip_jar=TunableTuple(description='\n            if this perk is active, there will be the possibility for the sims to leave a percentage of the service \n            as a tip.\n            ', default_tip=Tunable(description='\n                The tip by default that is given if the service/item value is 0\n                ', tunable_type=int, default=10), tip_types=TunableList(description='\n                List of amount baselines for each one of the Business Ranks, \n                to be used for to set the Hourly Fees for Attendance Sale system.\n                ', tunable=TunableTuple(description='\n                    Different levels of tips depending on the tip jar perk level unlocked \n                    ', tip_percent=TunablePercent(description='\n                        The percent of the service/item value that will be given as a tip.\n                        ', default=10), probability=TunablePercent(description='\n                        The percentage of probability for this tip to be applied.\n                        ', default=20), perk=TunableReference(description='\n                        The tip Jar perk level\n                        ', manager=services.get_instance_manager(sims4.resources.Types.BUCKS_PERK), pack_safe=True)))), eau_the_store_pheromone=OptionalTunable(description='\n            If this perk is active, a trait will be applied to the owner so that customers will stay longer in their \n            business when it is open.\n            ', tunable=TunableTuple(description="\n                If the sim has this trait, they will stay a 'percentage' more time visiting the small business.\n                ", percentage=TunablePercent(description='\n                    The percentage of time that the customer will stay longer in the \n                    business\n                    ', default=50), perk_trait=TunableReference(description='\n                    The perk that will change the customer visit time. \n                    ', manager=services.get_instance_manager(sims4.resources.Types.TRAIT), pack_safe=True))), customer_appreciation_day=OptionalTunable(description='\n            If the business owner has this buff, all the services and items will have a markup equal to 0\n            ', tunable=TunableTuple(description='\n                ', buff=TunableBuffReference(description='\n                    Buff reference for the Customer Appreciation Perk\n                    ', pack_safe=True), confirmation_dialog=UiDialogOkCancel.TunableFactory(description='\n                    A dialog that is shown when the customer appreciation day is still going on when trying to close the \n                    small business.\n                    '))), fake_employee_payment=OptionalTunable(description='\n            A reference to the buff that is applied to the employee to freeze their salary payment after use the "Fake \n            salary payment" interaction (from the perk "My name\'s Bill, no Bill") \n            ', tunable=TunableReference(description='\n                The relbit that is applied to the employee who has the "Fake salary payment" \n                enabled towards the business owner.\n                ', manager=services.get_instance_manager(sims4.resources.Types.RELATIONSHIP_BIT), class_restrictions=('RelationshipBit',), pack_safe=True)), viral_on_social_media=TunableTuple(description='\n            When unlocked this perk will make more customers appear in the business. \n            ', perk=TunablePackSafeReference(description='\n                The perk that makes the business more popular and boost the number of customers that come to the business.\n                ', manager=services.get_instance_manager(Types.BUCKS_PERK)), perk_name=TunableLocalizedString(description='\n                The display name of the perk.\n                ')), ultrasonic_whistle=TunableTuple(description='\n            When unlocked this perk will make the customers stay less time in the business with a low satisfaction. \n            ', trait=TunablePackSafeReference(description='\n                The trait that is applied to the sim when the Ultrasonic Whistle perk is unlocked and enabled.\n                ', manager=services.get_instance_manager(Types.TRAIT)), perk_name=TunableLocalizedString(description='\n                The display name of the perk.\n                ')))
    BUY_SMALL_BUSINESS_VENUE_LOT_AFFORDANCE = TunablePackSafeReference(description='\n        The affordance to buy a lot for this type of business.\n        ', manager=services.get_instance_manager(Types.INTERACTION), tuning_group=GroupNames.UI)
    ON_SOLD_SMALL_BUSINESS_VENUE_LOT_AFFORDANCE = OptionalTunable(description='\n        When enabled, the affordance to push when a small business venue lot is sold.\n        Used to animate the sim and display a TNS. The venue will be already sold at this time.\n        This is optional, as it is intended just for flair purposes.\n        ', tunable=TunablePackSafeReference(description='\n            The affordance to push on lot sale.\n            ', manager=services.get_instance_manager(Types.INTERACTION), tuning_group=GroupNames.UI))
    EMPLOYEE_SALARY_DATA = TunableMapping(description='\n        Data related to each salary level for small business employees. \n        ', key_type=SmallBusinessSalary, value_type=TunableTuple(normal_salary_icon=TunableIconAllPacks(description='\n                Icon shown on employees that have this salary level.\n                '), fake_salary_icon=TunableIconAllPacks(description='\n                Icon shown on employees whose salary is being faked.\n                ')))
    SMALL_BUSINESS_LOT_PURCHASE_DIALOG = UiDialogNotification.TunableFactory(description='\n        TNS that is displayed after buying a small business lot.\n        ')
    SUPPORTED_INTERACTIONLESS_MONEY_LOOT_TAGS = TunableTags(description='\n        Set of tags that represent the Money Loots that will be exceptionally tracked by the Interaction Sales system.\n        Usually due to a gain/loss generated by the end of a Situation, for instance, Yoga Classes.\n        ')
    SMALL_BUSINESS_VENUE_TUNING = TunablePackSafeReference(description='\n        The Small Business Venue lot tuning.\n        ', manager=services.get_instance_manager(Types.VENUE))
    LOOT_ON_REGISTER_BUSINESS = TunablePackSafeReference(description='\n        Loot to happen when a new business is registered, also applied when transferring business\n        ', manager=services.get_instance_manager(sims4.resources.Types.ACTION), class_restrictions=('LootActions',))
    LOOT_ON_UNREGISTER_BUSINESS = TunablePackSafeReference(description='\n        Loot to happen when a new business is unregistering, also applied when transferring business\n        ', manager=services.get_instance_manager(sims4.resources.Types.ACTION), class_restrictions=('LootActions',))
    TRAIT_ON_TRANSFER_BUSINESS = TunablePackSafeReference(description='\n        Loot to happen when a new business is transferred\n        ', manager=services.get_instance_manager(sims4.resources.Types.TRAIT))
    BUY_SMALL_BUSINESS_VENUE_TNS = UiDialogNotification.TunableFactory(description='\n        TNS that is displayed on unowned small business venue.\n        ')
    ASSIGN_VENUE_TO_SMALL_BUSINESS_TNS = UiDialogNotification.TunableFactory(description='\n        TNS to assign a small business to this venue.\n        ')
    ASSIGN_VENUE_TO_NEW_SMALL_BUSINESS_TNS = UiDialogNotification.TunableFactory(description='\n        TNS to create a small business and assign to this venue.\n        ')
    PURCHASED_LOT_AUTO_ASSIGNED_TO_SMALL_BUSINESS_TNS = UiDialogNotification.TunableFactory(description="\n        TNS when new small business venue lot is purchased and auto assigned to active sim's small business.\n        ")
    HIRED_TEMPORARY_EMPLOYEES_SITUATION_TAGS = TunableTags(description='\n        Set of tags that represent the situation roles that temporary employees (such as hired mixologists, vendors,\n        etc. that are hired directly from the object (bar, stand...)) are in.\n        This is used so the business knows to redirect money given to them to the business owner that hired them.\n        ')
    GHOST_TRAIT = TunableReference(description='\n        Ghost trait used for ghost attendance criteria (must match).\n        ', manager=services.get_instance_manager(sims4.resources.Types.TRAIT))

