import services
import sims4
from sims4.localization import TunableLocalizedString
from sims4.tuning.tunable import TunableReference, TunableResourceKey, OptionalTunable, TunableList, Tunable, TunableMapping
from sims4.tuning.tunable_base import GroupNames
from situations.situation_goal import TunableWeightedSituationGoalReference

class SituationGoalTuningMixin:
    INSTANCE_TUNABLES = FACTORY_TUNABLES = {'main_goal': TunableReference(description='\n            The main goal of the situation. e.g. Get Married\n            .', manager=services.get_instance_manager(sims4.resources.Types.SITUATION_GOAL), allow_none=True, tuning_group=GroupNames.GOALS), 'main_goal_audio_sting': TunableResourceKey(description='\n            The sound to play when the main goal of this situation\n            completes.\n            ', allow_none=True, default=None, resource_types=(sims4.resources.Types.PROPX,), tuning_group=GroupNames.AUDIO), 'minor_goal_chains': TunableList(description='\n            A list of goal sets, each one starting a chain of goal sets, for selecting minor goals.\n            The list is in priority order, first being the most important.\n            At most one goal will be selected from each chain.\n            ', tunable=TunableReference(description='\n                A goal set to use for selecting minor goals.\n                ', manager=services.get_instance_manager(sims4.resources.Types.SITUATION_GOAL_SET), class_restrictions=('SituationGoalSet',), pack_safe=True), tuning_group=GroupNames.GOALS), 'goal_sub_text': OptionalTunable(description='\n            If enabled, the tuned text will be shown under the goal list.\n            ', tunable=TunableLocalizedString(), tuning_group=GroupNames.GOALS), 'goal_button_text': OptionalTunable(description='\n            If enabled, button with tuned text will be added at \n            the bottom of goals display.\n            ', tunable=TunableLocalizedString(), tuning_group=GroupNames.GOALS), 'offer_completed_goals': Tunable(description='\n            If selected, goals that have been completed could be offered again.\n            ', tunable_type=bool, default=True, tuning_group=GroupNames.GOALS), 'activity_goals': TunableMapping(description='\n            Goals that will be set based off activities chosen. Ideally, there\n            should be goals for each of the activities in available_activities.\n            When one or more is tuned here with Activity Situation Goal Tracker, the\n            activity goal icon shows for the situation cell in Situation Creation UI.\n            ', key_name='Activity', key_type=TunableReference(description='\n                An available activity for this Situation.\n                ', manager=services.get_instance_manager(sims4.resources.Types.HOLIDAY_TRADITION), class_restrictions=('SituationActivity',), pack_safe=True), value_type=TunableList(description='\n                Weighted list of goals associated with this activity.\n                ', tunable=TunableWeightedSituationGoalReference(pack_safe=True)), tuning_group=GroupNames.GOALS)}

