import enum

class SimInfoLODLevel(enum.Int):
    MINIMUM = 1
    BACKGROUND = 10
    BASE = 25
    INTERACTED = 50
    FULL = 100
    ACTIVE = 125
    _prev_lod = {ACTIVE: FULL, FULL: INTERACTED, INTERACTED: BASE, BASE: BACKGROUND, BACKGROUND: MINIMUM}
    _next_lod = {INTERACTED: FULL, BASE: INTERACTED, BACKGROUND: BASE, MINIMUM: BACKGROUND}

    @staticmethod
    def get_previous_lod(from_lod):
        if from_lod in SimInfoLODLevel._prev_lod:
            return SimInfoLODLevel._prev_lod[from_lod]

    @staticmethod
    def get_next_lod(from_lod):
        if from_lod in SimInfoLODLevel._next_lod:
            return SimInfoLODLevel._next_lod[from_lod]

