from bucks.bucks_enums import BucksType
import services
import sims4.resources
from sims4.tuning.tunable import TunableEnumEntry, TunablePackSafeReference, TunablePackSafeResourceKey
from sims4.tuning.tunable_base import ExportModes, GroupNames

class GhostPowersTunables:
    GHOST_POWERS_RANKED_STATISTIC = TunablePackSafeReference(description='\n        The ranked statistic that is to be used for tracking ghost powers XP progress.\n        \n        This should not need to be tuned at all. If you think you need to tune\n        this please speak with a GPE before doing so.\n        ', manager=services.get_instance_manager(sims4.resources.Types.STATISTIC), class_restrictions=('RankedStatistic',), export_modes=ExportModes.ClientBinary)
    GHOST_POWERS_MANA_COMMODITY = TunablePackSafeReference(description='\n        The commodity that is to be used for tracking ghost powers mana/stamina.\n        ', manager=services.get_instance_manager(sims4.resources.Types.STATISTIC), class_restrictions=('Commodity',), export_modes=ExportModes.ClientBinary)
    GHOST_POWERS_GOOD_ULTIMATE_STATISTIC = TunablePackSafeReference(description='\n        The commodity that is to be used for tracking unlock progress for the ghost powers T5 good ability.\n        ', manager=services.get_instance_manager(sims4.resources.Types.STATISTIC), class_restrictions=('Statistic',), export_modes=ExportModes.All)
    GHOST_POWERS_EVIL_ULTIMATE_STATISTIC = TunablePackSafeReference(description='\n        The commodity that is to be used for tracking unlock progress for the ghost powers T5 evil ability.\n        ', manager=services.get_instance_manager(sims4.resources.Types.STATISTIC), class_restrictions=('Statistic',), export_modes=ExportModes.All)
    GHOST_POWERS_PERKS_BUCKS_TYPE = TunableEnumEntry(description='\n        A reference to the bucks type used for Ghost Powers Perks.\n        ', tunable_type=BucksType, default=BucksType.INVALID, pack_safe=True)
    GHOST_POWERS_GOOD_ULTIMATE_ICON = TunablePackSafeResourceKey(description='\n        Icon to be displayed on the Good Ultimate Icon Button on the Ghost Powers Perks Panel.\n        ', resource_types=sims4.resources.CompoundTypes.IMAGE, export_modes=ExportModes.All, tuning_group=GroupNames.UI)
    GHOST_POWERS_EVIL_ULTIMATE_ICON = TunablePackSafeResourceKey(description='\n        Icon to be displayed on the Evil Ultimate Icon Button on the Ghost Powers Perks Panel.\n        ', resource_types=sims4.resources.CompoundTypes.IMAGE, export_modes=ExportModes.All, tuning_group=GroupNames.UI)

