from interactions.utils.tunable_icon import TunableIconAllPacks
from sims4.tuning.tunable import TunableTuple, TunableList, TunablePackSafeReference, TunableVariant, Tunable, OptionalTunable, TunableMapping, TunableReference
from sims4.localization import TunableLocalizedStringFactory, TunableLocalizedString
from buffs.tunable import TunableBuffReference
from crafting.crafting_ingredients import IngredientRequirementByDef, IngredientRequirementByTag
import services
from sims4.resources import Types
from ui.ui_dialog import UiDialogOkCancel
from vfx import PlayEffect

class FamilyRecipesTuning:
    FAMILY_RECIPE_DATA = TunableTuple(description='\n        Family recipes config data\n        ', ingredients=TunableList(description='\n            List of ingredient requirements.\n            Test will succeed if all listed ingredient were used in the crafting process.\n            ', tunable=TunableVariant(description='\n                Possible ingredient mapping by object definition of by \n                catalog object Tag.\n                ', ingredient_by_definition=IngredientRequirementByDef.TunableFactory(ingredient_override=(True,)), ingredient_by_tag=IngredientRequirementByTag.TunableFactory())), buffs=TunableList(description='\n            The buffs to display in the family recipe creation picker dialog.\n            ', tunable=TunableTuple(buff_reference=TunableBuffReference(description='\n                    Buff reference to add to the family recipe.\n                    ', pack_safe=True), locked=Tunable(description='\n                    If checked, the buff have to be unlocked.\n                    ', tunable_type=bool, default=False), locked_tooltip=OptionalTunable(description='\n                    If defined, tooltip to be shown when buff is locked\n                    ', tunable=TunableLocalizedString()), buff_description=TunableLocalizedString(description='\n                    Description for family recipe buffs within the buff picker.\n                    '), icon=TunableIconAllPacks(description='\n                    Icon to be displayed for buff\n                    '))), family_recipe_text=TunableTuple(description='\n            Values to use when setting up the tooltips for family recipe.\n            ', buff_already_in_use_text=TunableLocalizedStringFactory(description='{0.String} currently uses this buff'), locked_buff=TunableLocalizedString(description='This buff is locked. Live experiences to unlock it.'), family_recipe_name_text=TunableLocalizedStringFactory(description='{0.String}')), cost_modifier_based_on_size=TunableMapping(description='\n            Adjust buff costs based on serving sizes\n            ', key_type=TunableReference(description='\n                The recipe quality state value.\n                ', manager=services.get_instance_manager(Types.OBJECT_STATE), class_restrictions='ObjectStateValue'), value_type=Tunable(description='\n                Modifier by which the price of recipes will be multiplied.\n                ', tunable_type=float, default=1)), family_recipe_vfx=PlayEffect.TunableFactory(description='\n            The effect to play on the crafted family recipe.\n            '), retroactive_buff_unlocks=TunableList(description='\n            A list of loots to apply to the sim. The loot list will be applied\n            to the Sim when the Sim is first initialized and the EP18 content is available.\n            ', tunable=TunableReference(description='\n                Loot applied to the sim to grant initial buff unlocks.\n                ', manager=services.get_instance_manager(Types.ACTION), class_restrictions=('LootActions',), pack_safe=True)))
    FAMILY_RECIPE_NOTEBOOK_DATA = TunableTuple(description='\n        Values to use when setting up the tooltips for family.\n        ', reference_notebook_entry=TunablePackSafeReference(description='\n           Reference to a notebook entry where we will get the core notebook\n           data (category, subcategory).   \n           ', manager=services.get_instance_manager(Types.NOTEBOOK_ENTRY)), family_recipe_notebook_text=TunableTuple(description='\n           Values to use when setting up the text tooltips for family recipe.\n           ', buff_notebook_text=TunableLocalizedStringFactory(description='Grants:'), extra_ingredient_notebook_text=TunableLocalizedStringFactory(description='Extra ingredient:'), base_recipe_notebook_text=TunableLocalizedStringFactory(description='Base recipe:'), original_creator_notebook_text=TunableLocalizedStringFactory(description='Original Creator: {0.String}')))
    FAMILY_RECIPE_REPLACE_DIALOG = UiDialogOkCancel.TunableFactory(description='\n        A dialog that is shown when a Sim is going to learn a family recipe \n        with a buff it already has in another family recipe.\n        ')

