from event_testing.tests import TunableTestSet
from routing.walkstyle.walkstyle_tuning import TunableWalkstyle
from sims4.tuning.tunable import AutoFactoryInit, HasTunableSingletonFactory, TunableMapping, TunableList, TunableTuple
import sims4.math
logger = sims4.log.Logger('WalkstyleOverrides')

class WalkstyleCarryOverrides(HasTunableSingletonFactory, AutoFactoryInit):
    CARRY_COMPATIBLE_WALKSTYLE_OVERRIDE_MAP = TunableMapping(description='\n        Provides an override to a given walkstyle if this Sim is carrying\n        another Sim. (ie. horse riding with a carried sim).\n        ', key_type=TunableWalkstyle(description='\n            The walkstyle to override when carrying a Sim.\n            ', pack_safe=True), value_type=TunableList(description='\n            A list of tested walkstyles which can be used\n            to override the walkstyle from an incoming\n            walkstyle request. The first passing walkstyle\n            will be selected.\n\n            If no tests pass, the walkstyle from the\n            request will be used.\n            ', tunable=TunableTuple(description='\n                A tuple containing a walkstyle and the tests\n                they need to pass to be selected.\n                ', walkstyle=TunableWalkstyle(description='\n                    A walkstyle that can be used as an override\n                    if its tests pass.\n                    ', pack_safe=True), tests=TunableTestSet(description='\n                    The tests used to determine if this walkstyle\n                    should be selected as an override.\n                    '))))

