from postures.posture_cost import TunablePostureCostVariant
from postures.posture_validators import TunablePostureValidatorVariant
from sims.sim_info_types import Species
from sims4.tuning.tunable import OptionalTunable, TunableTuple, TunableList, TunableMapping, TunableEnumEntry, Tunable

class TunableSupportedPostureTransitionData(OptionalTunable):

    def __init__(self, *args, **kwargs):
        super().__init__(*args, tunable=TunableTuple(cost=TunablePostureCostVariant(), target_species_cost_modifiers=TunableMapping(description='\n                    Define a set of multiplicative cost modifiers for this transition \n                    per target species. Only applicable for postures with sims as targets.\n                    \n                    Generally, this should be handled case-by-case via cost overrides or\n                    modifiers on relevant interactions and objects. In certain\n                    circumstances this may be useful if a particular transition\n                    between a specific pair of postures should always be modified.\n                    \n                    If a species does not appear in the mapping, it will stay at\n                    its original value.\n                    \n                    e.g. going from stand to beCarried when the target is a horse\n                    is always a higher cost than when the target is a human.\n                    ', key_type=TunableEnumEntry(description='\n                        The species this cost modifier applies to.\n                        ', tunable_type=Species, default=Species.HUMAN, invalid_enums=(Species.INVALID,)), value_type=Tunable(description='\n                        The value to multiply the cost by.\n                        ', tunable_type=float, default=1)), validators=TunableList(description='\n                    Define under what circumstances this transition is valid.\n                    There are performance implications of adding tested edges to\n                    the posture graph. \n                    \n                    In general, this should be handled by testing posture-\n                    providing interactions altogether. This should really only\n                    be used to restrict the ability to go from a specific\n                    posture to another specific posture under certain\n                    circumstances.\n                    \n                    e.g. Prevent Squeamish Sims from sitting on dirty toilets.\n                     * Do not use this tuning. Instead, test out the interaction\n                     directly.\n                     \n                    e.g. Prevent Toddlers with low motor skill from entering the\n                    High Chair posture from stand. However, allow them to be\n                    placed on the High Chair from carry.\n                     * Use this tuning.\n                    ', tunable=TunablePostureValidatorVariant())), enabled_by_default=True, **kwargs)

