import services
import sims4
from event_testing.tests import TunableTestSet
from filters.tunable import TunableSimFilter
from sims.bills_enums import AdditionalBillSource
from sims4.tuning.dynamic_enum import DynamicEnum
from sims4.tuning.tunable import TunableTuple, TunableList, TunableRange, TunableReference, TunablePackSafeReference, TunableEnumEntry, TunablePercent
from sims4.tuning.tunable_base import ExportModes
from tunable_multiplier import TunableMultiplier
from tunable_time import TunableTimeOfDay, TunableTimeSpan
from ui.ui_dialog_notification import TunableUiDialogNotificationSnippet

class MultiUnitEventType(DynamicEnum):
    INVALID = 0


class MultiUnitTuning:
    DEFAULT_SIGNED_LEASE_LENGTH = TunableRange(description="\n        Default length of a unit's lease. \n        ", tunable_type=int, default=7, minimum=1, export_modes=ExportModes.ClientBinary)
    MAX_RENT = TunableTuple(description='\n        Properties used to calculate max rent for rental unit business.\n        ', simolean_cost_per_tile=TunableRange(description='\n            The value used to calculated the maximum rental cost of the unit given tile amount.\n            e.x. A 500-tile unit with 2 simolean_cost_per_tile will result in a 1000 simolean cost for unit.\n            ', tunable_type=int, default=1, minimum=1), cost_modifiers=TunableMultiplier.TunableFactory(description='\n            The max rent modification multiplier.\n            '), min_tile_count=TunableRange(description='\n            The minimum tile count of a rental unit. This amount should be above zero to avoid 0 max rent for a unit.\n            ', tunable_type=int, default=1, minimum=1), initial_rent_percentage=TunablePercent(description='"\n            The percentage of the max rent that the initial rent will be set to. \n            ', default=50))
    TAXES_PER_UNIT = TunableRange(description='\n        Amount of tax to pay per unit \n        ', tunable_type=int, default=100, minimum=0, export_modes=ExportModes.ClientBinary)
    TAXES_PER_UNIT_BILL_SOURCE = TunableEnumEntry(description='\n            The bill_source tied to the Taxes Per Rental Unit.\n            This is used to identify which group to place the total taxes per unit into\n            in the additional_bill_costs list', tunable_type=AdditionalBillSource, default=AdditionalBillSource.Miscellaneous)
    ON_RENT_INCREASE_LOOT = TunableList(description='\n        A list of loots that will be applied when a rent increase happens to a occupied rental unit.\n        ', tunable=TunableReference(manager=services.get_instance_manager(sims4.resources.Types.ACTION), class_restrictions=('LootActions',), pack_safe=True))
    GRACE_PERIOD = TunableTuple(description='\n        Grace period tuning        \n        ', starting_time=TunableTimeOfDay(description='\n            Time at which the grace period starts on the day after the lease ends.  To be used to disable penalties\n            when adjusting lease terms.\n            '), duration=TunableTimeSpan(description='\n            How long the grace period lasts.\n            ', default_days=1))
    TIME_BETWEEN_FILL_VACANCY_DATA_REFRESH = TunableTimeSpan(description='\n        The amount of time, in sim hours, between Fill Vacancy panel data refreshes.\n        ', default_hours=12)
    NO_TENANT_LEFT_NOTIFICATION = TunableUiDialogNotificationSnippet(description='\n        Notification that triggers when there are no tenants left in the tenant household.\n        ')


class PropertyOwnerTuning:
    NPC_PROPERTY_OWNER_FILTER = TunablePackSafeReference(description='\n        The Sim Filter used to find/create an npc property owner in game.\n        ', manager=services.get_instance_manager(sims4.resources.Types.SIM_FILTER), class_restrictions=('TunableSimFilter',))
    PROPERTY_OWNER_REL_BIT = TunablePackSafeReference(description='\n        The rel bit to add to the property owner on rel between every member of the\n        property owner hh and tenant hh.\n        ', manager=services.get_instance_manager(sims4.resources.Types.RELATIONSHIP_BIT), class_restrictions=('RelationshipBit',))
    TENANT_REL_BIT = TunablePackSafeReference(description='\n        The rel bit to add to the tenant on rel between every member of the\n        property owner hh and tenant hh.\n        ', manager=services.get_instance_manager(sims4.resources.Types.RELATIONSHIP_BIT), class_restrictions=('RelationshipBit',))
    PROPERTY_OWNER_SIM_TESTS = TunableTestSet(description='\n       Tests to run before applying the property owner rel bit to property owner hh sims.\n       ')
    TENANT_SIM_TESTS = TunableTestSet(description='\n        Tests to run before applying the tenant rel bit to tenant hh sims.\n       ')
    TENANT_EVICTION_AFFORDANCE = TunablePackSafeReference(description="\n        Interaction to apply to a tenant to evict the tenant's household from a rental unit\n        ", manager=services.get_instance_manager(sims4.resources.Types.INTERACTION))
    PROPERTY_OWNER_EVICTION_LOOT = TunableList(description='\n        A list of loots that will be applied to the property owner after an eviction\n        ', tunable=TunableReference(manager=services.get_instance_manager(sims4.resources.Types.ACTION), class_restrictions=('LootActions',), pack_safe=True))

