import services
import sims4.log
from buffs.tunable import TunableBuffReference
from sims4.localization import TunableLocalizedStringFactoryVariant, TunableLocalizedString, TunableLocalizedStringSnippet, TunableLocalizedStringFactory
from sims4.tuning.tunable import TunableReference, TunableTuple, TunableEnumEntry, TunableList, Tunable, TunablePackSafeReference, TunableMapping, TunableColor
from tag import Tag

class JewelryCraftingTuning:
    JEWELRY_DATA = TunableTuple(description='\n        Jewelry config data\n        ', purchasable_crystals=TunableList(description=",\n            List of crystals to be used in recipes that can be purchased if the user doesn't have them in the inventory \n            ", tunable=TunableReference(description='\n                Crystal definition\n                ', manager=services.definition_manager(), pack_safe=True)), non_purchasable_crystals=TunableList(description=",\n            List of crystals to be used in recipes that CAN'T be purchased if the user doesn't have them in the inventory \n            ", tunable=TunableReference(description='\n                Crystal definition\n                ', manager=services.definition_manager(), pack_safe=True)), purchasable_metals=TunableList(description=",\n            List of metals to be used in recipes that can be purchased if the user doesn't have them in the inventory \n            ", tunable=TunableReference(description='\n                Metal definition\n                ', manager=services.definition_manager(), pack_safe=True)), non_purchasable_metals=TunableList(description=",\n            List of metals to be used in recipes that CAN'T be purchased if the user doesn't have them in the inventory \n            ", tunable=TunableReference(description='\n                Metal definition\n                ', manager=services.definition_manager(), pack_safe=True)), purchase_multiplier=Tunable(description='\n            Price multiplier to be applied when purchasing \n            ', tunable_type=float, default=1), gemstone_cutting_recipes=TunableList(description='\n            The recipes to display in the gemstone cutting picker dialog\n            ', tunable=TunableReference(description='\n                Recipe to craft.\n                ', manager=services.get_instance_manager(sims4.resources.Types.RECIPE), pack_safe=True)), jewelry_recipes=TunableList(description='\n            The recipes to display in the jewelry picker dialog\n            ', tunable=TunableReference(description='\n                Recipe to craft.\n                ', manager=services.get_instance_manager(sims4.resources.Types.RECIPE), pack_safe=True)), metal_state=TunablePackSafeReference(description='\n            Metal state that will be used to get which metal state value the object is in\n            ', manager=services.get_instance_manager(sims4.resources.Types.OBJECT_STATE), class_restrictions='ObjectState'), crystal_state=TunablePackSafeReference(description='\n            Crystal state that will be used to get which metal state value the object is in\n            ', manager=services.get_instance_manager(sims4.resources.Types.OBJECT_STATE), class_restrictions='ObjectState'), crystal_state_buff_map=TunableMapping(description='\n            Map that defines which buff will be applied depending on the crystal state\n            Key: crystal: Crystal State\n            Value: buff\n            ', key_name='crystal states', value_name='buff', value_type=TunableBuffReference(description='\n                Buff that will be applied.', pack_safe=True), key_type=TunableReference(description='\n                Crystal state', manager=services.get_instance_manager(sims4.resources.Types.OBJECT_STATE), pack_safe=True)), crystal_definition_effects_strings_map=TunableMapping(description='\n            Map that defines which the strings to show in the UI picker\n            Key: crystal: definition\n            Value: List of strings\n            ', key_name='crystal', value_name='strings', value_type=TunableList(description='\n                List of effect strings\n                ', tunable=TunableLocalizedStringSnippet(pack_safe=True)), key_type=TunableReference(description='\n                Crystal', manager=services.definition_manager(), pack_safe=True)), drained_state_value=TunableReference(description='\n            Jewelry drained state that will be used in Jewelry Component to check if the buff will be added or not\n            ', manager=services.get_instance_manager(sims4.resources.Types.OBJECT_STATE), class_restrictions='ObjectStateValue', pack_safe=True), draining_state_value=TunableReference(description='\n            Jewelry draining state that will be used in Chargeable Component to update the tooltip accordingly\n            ', manager=services.get_instance_manager(sims4.resources.Types.OBJECT_STATE), class_restrictions='ObjectStateValue', pack_safe=True), drained_buff=TunableBuffReference(description='\n            Buff that gets added to the sims when they are wearing drained jewelry \n            ', allow_none=True, pack_safe=True), bad_energy_state_value=TunableReference(description='\n            Bad energy state value that will be used in Jewelry Component to check if the tense buff will be added or not\n            ', manager=services.get_instance_manager(sims4.resources.Types.OBJECT_STATE), class_restrictions='ObjectStateValue', pack_safe=True), wearing_states=TunableTuple(description='\n            States related to wear status of jewelry\n            ', worn_in_current_outfit=TunableReference(description='\n                Worn in current outfit\n                ', manager=services.get_instance_manager(sims4.resources.Types.OBJECT_STATE), class_restrictions='ObjectStateValue'), worn_in_other_outfit=TunableReference(description='\n                Worn in outfits which are no the current one\n                ', manager=services.get_instance_manager(sims4.resources.Types.OBJECT_STATE), class_restrictions='ObjectStateValue'), not_worn=TunableReference(description='\n                Not worn\n                ', manager=services.get_instance_manager(sims4.resources.Types.OBJECT_STATE), class_restrictions='ObjectStateValue')), material_picker_tooltip=TunableTuple(description='\n            Values to use when setting up the tooltips for the materials pickers\n            ', if_charged_text=TunableLocalizedString(description='If charged... text'), not_purchasable_design_text=TunableLocalizedStringFactory(description='\n                Not purchasable shape/gemstone text.\n                Must contain {0.Number} to show the unlock level'), not_purchasable_metal_text=TunableLocalizedString(description='Not purchasable metal text'), not_purchasable_crystal_text=TunableLocalizedString(description='Not purchasable crystal text'), design_without_crystal_text=TunableLocalizedString(description='Design without crystal text'), rarity_color=TunableColor(description='Color for rarity'), effects_color=TunableColor(description='Color of crystal effects'), cost_color=TunableColor(description='Color for cost')))
    __annotations__['JEWELRY_DATA'] = TunableTuple
    JEWELRY_NO_CRYSTAL_NEEDED_TAG = TunableEnumEntry(description='"\n        Tag to see if the jewelry needs a crystal.\n        ', tunable_type=Tag, default=Tag.INVALID, invalid_enums=(Tag.INVALID,), pack_safe=True)
    MATERIAL_IN_INVENTORY_TAG = TunableEnumEntry(description='"\n        Tag to see if the material is in the inventory.\n        ', tunable_type=Tag, default=Tag.INVALID, invalid_enums=(Tag.INVALID,), pack_safe=True)

