from gsi_handlers.gameplay_archiver import GameplayArchiver
from sims4.gsi.schema import GsiGridSchema
import gsi_handlers
state_trigger_schema = GsiGridSchema(label='State Triggers/State Trigger Log')
state_trigger_schema.add_field('objId', label='Object Id', unique_field=True, width=1.2)
state_trigger_schema.add_field('def', label='Definition', width=2)
state_trigger_schema.add_field('name', label='Object Name', width=2)
state_trigger_schema.add_field('parent', label='Parent', width=1.5)
state_trigger_schema.add_field('state', label='Trigger State', width=1.5)
state_trigger_schema.add_field('state_value', label='Trigger State Value', width=2)
state_trigger_schema.add_field('at_state', label='Triggered At State', width=2.5)
state_trigger_schema.add_field('at_states', label='At States', width=2.5)
state_trigger_schema.add_field('src', label='Source', width=1.3)
state_trigger_archiver = GameplayArchiver('StateTriggerLog', state_trigger_schema)

def archive_state_trigger(obj, triggered_state, at_state, at_states, source=''):
    archive_data = {'objId': hex(obj.id), 'def': obj.definition.name, 'name': obj.custom_name if obj.has_custom_name() else '{} ({})'.format(hex(obj.catalog_name), gsi_handlers.gsi_utils.format_object_name(obj)), 'state': str(triggered_state.state), 'state_value': str(triggered_state), 'at_state': str(at_state), 'at_states': str(at_states), 'src': source}
    if obj.parent is not None:
        archive_data['parent'] = gsi_handlers.gsi_utils.format_object_name(obj.parent)
    state_trigger_archiver.archive(data=archive_data)

timed_state_trigger_schema_all = GsiGridSchema(label='State Triggers/Timed State Trigger All Log')
timed_state_trigger_schema_all.add_field('objId', label='Object Id', unique_field=True)
timed_state_trigger_schema_all.add_field('def', label='Definition', width=2)
timed_state_trigger_schema_all.add_field('name', label='Object Name', width=2.5)
timed_state_trigger_schema_all.add_field('state', label='Trigger State', width=2)
timed_state_trigger_schema_all.add_field('state_value', label='Trigger State Value', width=2)
timed_state_trigger_schema_all.add_field('at_state', label='At State', width=2)
timed_state_trigger_schema_all.add_field('status_type', label='Status', width=0.5)
timed_state_trigger_schema_all.add_field('rescheduled', label='Rescheduled?', width=0.75)
timed_state_trigger_schema_all.add_field('trigger_time', label='Trigger Time', width=1)
timed_state_trigger_archiver = GameplayArchiver('TimedStateTriggerLog', timed_state_trigger_schema_all)
timed_state_trigger_schema_selected = GsiGridSchema(label='State Triggers/Timed State Trigger Selected Log')
timed_state_trigger_schema_selected.add_field('objId', label='Object Id', unique_field=True)
timed_state_trigger_schema_selected.add_field('def', label='Definition', width=2)
timed_state_trigger_schema_selected.add_field('name', label='Object Name', width=2.5)
timed_state_trigger_schema_selected.add_field('state', label='Trigger State', width=2)
timed_state_trigger_schema_selected.add_field('state_value', label='Trigger State Value', width=2)
timed_state_trigger_schema_selected.add_field('at_state', label='At State', width=2)
timed_state_trigger_schema_selected.add_field('trigger_time', label='Trigger Time', width=1)
timed_state_trigger_archiver_selected = GameplayArchiver('TimedStateTriggerSelectedLog', timed_state_trigger_schema_selected)
timed_state_trigger_schema_failed = GsiGridSchema(label='State Triggers/Timed State Trigger Failed Log')
timed_state_trigger_schema_failed.add_field('objId', label='Object Id', unique_field=True)
timed_state_trigger_schema_failed.add_field('def', label='Definition', width=2)
timed_state_trigger_schema_failed.add_field('name', label='Object Name', width=2.5)
timed_state_trigger_schema_failed.add_field('state', label='Trigger State', width=2)
timed_state_trigger_schema_failed.add_field('state_value', label='Trigger State Value', width=2)
timed_state_trigger_schema_failed.add_field('at_state', label='At State', width=2)
timed_state_trigger_schema_failed.add_field('trigger_time', label='Trigger Time', width=1)
timed_state_trigger_schema_failed.add_field('rescheduled', label='Rescheduled?', width=0.75)
timed_state_trigger_archiver_failed = GameplayArchiver('TimedStateTriggerFailedLog', timed_state_trigger_schema_failed)

def archive_timed_state_trigger(obj, triggered_state, at_state, trigger_time, status_type=None, rescheduled=None):
    archive_data = {'objId': hex(obj.id), 'def': obj.definition.name, 'name': obj.custom_name if obj.has_custom_name() else '{} ({})'.format(hex(obj.catalog_name), gsi_handlers.gsi_utils.format_object_name(obj)), 'state': str(triggered_state.state), 'state_value': str(triggered_state), 'at_state': str(at_state), 'status_type': status_type, 'rescheduled': rescheduled, 'trigger_time': round(trigger_time, 2)}
    timed_state_trigger_archiver.archive(data=archive_data)
    if status_type == 'SELECTED':
        timed_state_trigger_archiver_selected.archive(data=archive_data)
    elif status_type == 'FAILED':
        timed_state_trigger_archiver_failed.archive(data=archive_data)

