from date_and_time import create_time_span
from interactions import ParticipantTypeSingleSim
from interactions.object_rewards import ObjectRewardsOperation
from interactions.utils import LootType
from sims4.tuning.instances import HashedTunedInstanceMetaclass, TuningClassMixin
from sims4.tuning.tunable import TunableSimMinute, OptionalTunable, HasTunableSingletonFactory, AutoFactoryInit, TunableEnumEntry
from sims4.utils import blueprintmethod, constproperty
from ui.ui_dialog_notification import TunableUiDialogNotificationSnippet
import services
import sims4.resources

class ScheduledDeliveryLoot(HasTunableSingletonFactory, AutoFactoryInit, TuningClassMixin, metaclass=HashedTunedInstanceMetaclass, manager=services.get_instance_manager(sims4.resources.Types.ACTION)):
    INSTANCE_TUNABLES = {'participant': TunableEnumEntry(description='\n            Sim who is getting the delivery delivered to their household.\n            ', tunable_type=ParticipantTypeSingleSim, default=ParticipantTypeSingleSim.Actor), 'time_from_now': TunableSimMinute(description='\n            How far from now we want our delivery.\n            ', default=1440, minimum=1, maximum=10080), 'not_home_notification': OptionalTunable(description='\n            If enabled, a notification will be displayed when the Sim is not\n            currently home when the object(s) would be delivered.\n            The object will be in the mailbox when they arrive back at their\n            home lot.\n            ', tunable=TunableUiDialogNotificationSnippet()), 'at_home_notification': OptionalTunable(description='\n            The notification that will be displayed when the Sim is at\n            home when the object(s) would be delivered. The object(s)\n            will end up in hidden inventory waiting to be delivered by\n            the mailman.\n            ', tunable=TunableUiDialogNotificationSnippet()), 'objects_to_deliver': ObjectRewardsOperation.TunableFactory(description='\n            The objects to be delivered. When participants are used \n            within this structure, only Sim-type participants will resolve.\n            ', locked_args={'notification': None, 'place_in_mailbox': True, 'force_family_inventory': False})}

    @constproperty
    def loot_type():
        return LootType.SCHEDULED_DELIVERY

    @blueprintmethod
    def apply_to_resolver(self, resolver, skip_test=False):
        subject = resolver.get_participant(self.participant)
        subject.household.delivery_tracker.request_delivery(self.guid64, subject.sim_id, create_time_span(minutes=self.time_from_now))

