import enum
import services
import sims4
from cheat_sheet.cheat_sheet_enums import CheatSheetMode
from sims4.localization import TunableLocalizedStringFactory
from sims4.tuning.instances import HashedTunedInstanceMetaclass
from sims4.tuning.tunable import TunableList, TunableTuple, TunableSet, TunableEnumEntry, TunableVariant
from sims4.tuning.tunable_hash import TunableStringHash64

class CheatSheetItem(metaclass=HashedTunedInstanceMetaclass, manager=services.get_instance_manager(sims4.resources.Types.CHEAT_SHEET)):
    INSTANCE_TUNABLES = {'controls': TunableList(description='\n            The entire set of cheat sheet hints. We iterate over this, checking each item\n            against its tests to determine which should be visible.\n            ', tunable=TunableTuple(control_elements=TunableList(description='\n                    List of elements that define this control item, which may be either names of Keyframes, \n                    or strings to display in this line item on the Cheat Sheet\n                    ', tunable=TunableVariant(description='\n                        Every Control ElementEither a string that defines a keyframe, or a localized string to display\n                        ', keyframe_icon=TunableStringHash64(description='\n                            When variant is this type, defines the keyframe in CheatSheetIcon in GuiComponentLibrary.fla\n                            to display                  \n                            '), string_control=TunableLocalizedStringFactory(description='\n                            When variant is this type, specifies the localized string to display in this element\n                            '))), item_description=TunableLocalizedStringFactory(description='\n                    Localized text to display next to to the icon\n                    '), conditions=TunableSet(tunable=TunableEnumEntry(description="\n                        Set of conditions that, when true, activate this item in the list.\n                        EG, TS3_CAMERA_ACTIVE + IN_LIVE_MODE will be visible when the TS3 camera\n                        is active and the user is in Live Mode, and invisible if either of those aren't true                                \n                        ", default=CheatSheetMode.INVALID, invalid_enums=(CheatSheetMode.INVALID,), tunable_type=CheatSheetMode))))}

