import services
import sims4
from sims4.tuning.instances import HashedTunedInstanceMetaclass
from sims4.tuning.tunable import TunableMapping, TunableReference
from sims4.tuning.tunable_base import ExportModes

class CasStoriesTraitChooser(metaclass=HashedTunedInstanceMetaclass, manager=services.get_instance_manager(sims4.resources.Types.CAS_STORIES_TRAIT_CHOOSER)):
    INSTANCE_TUNABLES = {'traits': TunableMapping(description='\n            A mapping between the weighting value and the trait that will be\n            assigned. The keys of this map are thresholds. Example: if the\n            desired behavior would be to assign trait_a if the weighting w is \n            between 0.0 and 1.0 and trait_b if w > 1.0, then this map should \n            have two entries: (0.0, trait_a), (1.0, trait_b). The weighting of \n            the lowest weighted trait should always be 0.0, and a weighting of\n            0.0 will always select the lowest trait by convention (although the\n            thresholds are otherwise non-inclusive).\n            ', key_type=float, value_type=TunableReference(manager=services.get_instance_manager(sims4.resources.Types.TRAIT), class_restrictions=('Trait',)), key_name='weighting_threshold', value_name='trait_to_assign', tuple_name='CasStoriesTraitChooserThresholds', minlength=1, export_modes=(ExportModes.ClientBinary,))}

