import services
import sims4
from sims4.localization import TunableLocalizedStringFactory
from sims4.tuning.instances import HashedTunedInstanceMetaclass
from sims4.tuning.tunable import TunableList, TunableTuple, TunableVariant, Tunable, TunableReference
from sims4.tuning.tunable_base import ExportModes, GroupNames

class CasStoriesAnswer(metaclass=HashedTunedInstanceMetaclass, manager=services.get_instance_manager(sims4.resources.Types.CAS_STORIES_ANSWER)):
    INSTANCE_TUNABLES = {'text': TunableLocalizedStringFactory(description='\n            The text of this answer.\n            ', export_modes=ExportModes.ClientBinary, tuning_group=GroupNames.UI), 'weightings': TunableList(description='\n            A list of objects to apply weightings to if this answer is \n            selected. Weight is the weight that shoudld be added to the chance \n            to receive this object.  In the latter case a trait will be \n            selected from the trait chooser based on its cumulative weighting \n            throughout the CAS Stories survey.\n            ', tunable=TunableTuple(weighted_object=TunableVariant(trait=TunableReference(manager=services.get_instance_manager(sims4.resources.Types.TRAIT), class_restrictions=('Trait',)), trait_chooser=TunableReference(manager=services.get_instance_manager(sims4.resources.Types.CAS_STORIES_TRAIT_CHOOSER), class_restrictions=('CasStoriesTraitChooser',)), aspiration_track=TunableReference(manager=services.get_instance_manager(sims4.resources.Types.ASPIRATION_TRACK)), default='trait'), weight=Tunable(tunable_type=float, default=0.0), export_class_name='CASAnswerWeightings'), export_modes=ExportModes.ClientBinary)}

