import services
import sims4
from interactions.utils.display_mixin import get_display_mixin
from sims4.tuning.instances import HashedTunedInstanceMetaclass
from sims4.tuning.tunable import Tunable, TunableInterval
from sims4.tuning.tunable_base import ExportModes
CasPreferenceDisplayMixin = get_display_mixin(has_description=True, has_icon=True, has_tooltip=True, use_string_tokens=True, has_secondary_icon=True, export_modes=ExportModes.ClientBinary, enabled_by_default=True)

class CasPreferenceCategory(CasPreferenceDisplayMixin, metaclass=HashedTunedInstanceMetaclass, manager=services.get_instance_manager(sims4.resources.Types.CAS_PREFERENCE_CATEGORY)):
    INSTANCE_TUNABLES = {'decorator_preference': Tunable(description='\n            If True, the preference category will be used by the GP10 Decorator\n            Career as a source of preferences to create performance benchmarks for\n            a Decorator Gig.\n\n            If False, this preference will not be used by the Decorator Gig.\n            ', tunable_type=bool, default=False), '_randomization_number_of_preferences': TunableInterval(description='\n            When randomizing preferences, how many preferences do we\n            want to pick for this category?\n            ', tunable_type=int, minimum=0, default_lower=1, default_upper=5, export_modes=ExportModes.All, export_class_name='RandomPreferencesTunableInterval')}

