from __future__ import annotations
from tunable_time import TunableTimeOfDay
from typing import TYPE_CHECKING
if TYPE_CHECKING:
    from typing import *
from business.unit_rating.unit_rating_enums import RatingSubScore, ModifyDynamicUnitRating, RatingContributionObject
from sims4.tuning.tunable import TunableMapping, Tunable, TunableEnumEntry, TunableRange, TunableInterval
from sims4.tuning.tunable_base import ExportModes, EnumBinaryExportType
from tag import TunableTag, TunableTags

class UnitRatingTuning:
    MAINTENANCE_RATING_START_VALUE = Tunable(description='\n        The starting value for the Maintenance Rating score. \n        ', tunable_type=int, default=-100, export_modes=ExportModes.ClientBinary)
    MAINTENANCE_RATING_BOUNDS = TunableInterval(description='\n        The minimum and maximum values for Maintenance Rating.\n        ', tunable_type=int, default_lower=-100, default_upper=100)
    SQUARE_FOOTAGE = TunableMapping(description='\n        A mapping of square footage to unit rating score. All values must be the same value apart for this to function.\n        ', key_type=int, key_name='SquareFootage', value_type=int, value_name='UnitRating', export_modes=ExportModes.ClientBinary, tuple_name='SquareFootageMapping')
    SQUARE_FOOTAGE_STEP = Tunable(description='\n        The value between any two steps in the square footage map. Used for rounding in the calculation of unit rating.\n        ', tunable_type=int, default=100, export_modes=ExportModes.ClientBinary)
    IN_UNIT_ENVIRONMENT_SCORE = TunableMapping(description='\n        A mapping of environment score of objects within a single unit to unit rating score. All values must be the same\n        value apart for this to function.\n        ', key_type=int, key_name='EnvironmentScore', value_type=int, value_name='UnitRating', export_modes=ExportModes.ClientBinary, tuple_name='InUnitEnvironmentScoreMapping')
    IN_UNIT_ENVIRONMENT_SCORE_STEP = Tunable(description='\n        The value between any two steps in the environment score map. Used for rounding in the calculation of unit \n        rating.\n        ', tunable_type=int, default=10, export_modes=ExportModes.ClientBinary)
    SHARED_ENVIRONMENT_SCORE = TunableMapping(description='\n        A mapping of environment score of objects in shared space to unit rating score. All values must be the same\n        value apart for this to function.\n        ', key_type=int, key_name='EnvironmentScore', value_type=int, value_name='UnitRating', export_modes=ExportModes.ClientBinary, tuple_name='SharedEnvironmentScore')
    SHARED_ENVIRONMENT_SCORE_STEP = Tunable(description='\n        The value between any two steps in the environment score map. Used for rounding in the calculation of unit \n        rating.\n        ', tunable_type=int, default=10, export_modes=ExportModes.ClientBinary)
    TOILET_COUNT = TunableMapping(description='\n        A mapping of the number of toilets inside of a unit to unit rating score.\n        ', key_type=int, key_name='NumToilets', value_type=int, value_name='UnitRating', export_modes=ExportModes.ClientBinary, tuple_name='ToiletCount')
    BED_COUNT = TunableMapping(description='\n        A mapping of the number of beds inside of a unit to unit rating score.\n        ', key_type=int, key_name='NumBeds', value_type=int, value_name='UnitRating', export_modes=ExportModes.ClientBinary, tuple_name='BedCount')
    SHOWER_TUB_COUNT = TunableMapping(description='\n        A mapping of the number of showers/tubs inside of a unit to unit rating score.\n        ', key_type=int, key_name='NumShowerTub', value_type=int, value_name='UnitRating', export_modes=ExportModes.ClientBinary, tuple_name='ShowerTubCount')
    STOVE_OVEN_COUNT = TunableMapping(description='\n        A mapping of the number of stoves/ovens inside of a unit to unit rating score.\n        ', key_type=int, key_name='NumStoveOven', value_type=int, value_name='UnitRating', export_modes=ExportModes.ClientBinary, tuple_name='StoveOvenCount')
    FRIDGE_COUNT = TunableMapping(description='\n        A mapping of the number of refrigerators inside of a unit to unit rating score.\n        ', key_type=int, key_name='NumFridge', value_type=int, value_name='UnitRating', export_modes=ExportModes.ClientBinary, tuple_name='FridgeCount')
    PERSONAL_AMENITY_COUNT = TunableMapping(description='\n        A mapping of the number of personal amenities inside a unit to unit rating score.\n        ', key_type=int, key_name='NumPersonalAmenity', value_type=int, value_name='UnitRating', export_modes=ExportModes.ClientBinary, tuple_name='PersonalAmenityCount')
    SHARED_AMENITY_COUNT = TunableMapping(description='\n        A mapping of the number of personal amenities outside a unit to unit rating score.\n        ', key_type=int, key_name='NumSharedAmenity', value_type=int, value_name='UnitRating', export_modes=ExportModes.ClientBinary, tuple_name='SharedAmenityCount')
    PERSONAL_TAG_TO_RATING_CONTRIBUTION = TunableMapping(description='\n        Maps tags to their rating contribution object enum.\n        ', key_type=TunableTag(description='\n            The object tag that will map to a rating contribution object enum.\n            '), key_name='PersonalTag', value_type=TunableEnumEntry(description='\n            The rating contribution object enum.\n            ', tunable_type=RatingContributionObject, default=RatingContributionObject.RCO_INVALID), value_name='RatingContributionObject', export_modes=ExportModes.ClientBinary, tuple_name='PersonalTagToRatingContribution')
    SHARED_TAG_TO_RATING_CONTRIBUTION = TunableMapping(description='\n        Maps tags to their rating contribution object enum.\n        ', key_type=TunableTag(description='\n            The object tag that will map to a rating contribution object enum.\n            '), key_name='SharedTag', value_type=TunableEnumEntry(description='\n            The rating contribution object enum.\n            ', tunable_type=RatingContributionObject, default=RatingContributionObject.RCO_INVALID), value_name='RatingContributionObject', export_modes=ExportModes.ClientBinary, tuple_name='TagToRatingContribution')


class UnitRatingSubcatTuning:
    UNIT_SIZE_TO_RATING = TunableMapping(description="\n        Unit size, in square footage, to subcategory rating. The square footage that's provided as the key should be\n        considered a minimum value for that rating to be selected.\n        ", key_type=int, key_name='MinUnitSize', value_type=TunableEnumEntry(description='\n            An enum that shows which subcategory rating each score maps to.\n            ', tunable_type=RatingSubScore, default=RatingSubScore.MEDIUM, binary_type=EnumBinaryExportType.EnumUint32), value_name='RatingSubScore', export_modes=ExportModes.ClientBinary, tuple_name='UnitSizeToRating')
    ENVIRONMENT_SCORE_TO_RATING = TunableMapping(description="\n        Combined (in-unit and shared) environment score to subcategory rating. The score that's provided as the key \n        should be considered a minimum value for that rating to be selected.\n        ", key_type=int, key_name='EnvironmentScore', value_type=TunableEnumEntry(description='\n            An enum that shows which subcategory rating each score maps to.\n            ', tunable_type=RatingSubScore, default=RatingSubScore.MEDIUM, binary_type=EnumBinaryExportType.EnumUint32), value_name='RatingSubScore', export_modes=ExportModes.ClientBinary, tuple_name='EnvironmentScoreToRating')
    AMENITIES_TO_RATING = TunableMapping(description="\n        Number of beds, toilets, etc. to subcategory rating. The amenity score that's provided as the key should be\n        considered a minimum value for that rating to be selected.\n        ", key_type=int, key_name='Amenities', value_type=TunableEnumEntry(description='\n            An enum that shows which subcategory rating each score maps to.\n            ', tunable_type=RatingSubScore, default=RatingSubScore.MEDIUM, binary_type=EnumBinaryExportType.EnumUint32), value_name='RatingSubScore', export_modes=ExportModes.ClientBinary, tuple_name='AmenitiesToRating')
    MAINTENANCE_TO_RATING = TunableMapping(description="\n        Dynamic rating score to subcategory rating. The dynamic rating that's provided as the key should be\n        considered a minimum value for that rating to be selected.\n        ", key_type=int, key_name='Maintenance', value_type=TunableEnumEntry(description='\n            An enum that shows which subcategory rating each score maps to.\n            ', tunable_type=RatingSubScore, default=RatingSubScore.MEDIUM, binary_type=EnumBinaryExportType.EnumUint32), value_name='RatingSubScore', export_modes=ExportModes.ClientBinary, tuple_name='MaintenanceToRating')


class DynamicUnitRatingTuning:
    RATING_CHANGE = TunableMapping(description='\n        A mapping of rating change size to actual rating change.\n        ', key_type=TunableEnumEntry(description='\n            The unit rating change size.\n            ', tunable_type=ModifyDynamicUnitRating, default=ModifyDynamicUnitRating.SMALL_LOSS), key_name='modify_dynamic_unit_rating', value_type=TunableRange(description='\n            The range that any dynamic unit rating change could exist within.\n            ', tunable_type=int, minimum=-100, maximum=100, default=0), value_name='unit_rating_change')
    RATING_CHANGE_CLEAR_ALERT_TIME = TunableTimeOfDay(description='\n        The time of day to clear all the UI alerts representing unit rating changes \n        in the biz panel for units. \n        ', default_hour=23)

