from business.unit_rating.unit_rating_enums import RatingSubScore, UnitRatingCategoryType
from display_snippet_tuning import DisplaySnippet
from interactions.utils.tunable_icon import TunableIcon
from sims4.localization import TunableLocalizedString
from sims4.tuning.tunable import TunableMapping, TunableEnumEntry, TunableTuple
import sims4
from sims4.tuning.tunable_base import ExportModes, EnumBinaryExportType
logger = sims4.log.Logger('UnitRatingCategory', default_owner='jsampson')

class UnitRatingCategory(DisplaySnippet):
    INSTANCE_TUNABLES = {'category_type': TunableEnumEntry(description='\n            A UnitRatingCategoryType.\n            ', tunable_type=UnitRatingCategoryType, default=UnitRatingCategoryType.SIZE, export_modes=ExportModes.All, binary_type=EnumBinaryExportType.EnumUint32), 'sub_scores': TunableMapping(description='\n            Mapping of RatingSubScore enum to the data about the sub score (ie. icon, name). \n            ', key_name='RatingSubScore', key_type=TunableEnumEntry(description='\n                A RatingSubScore.\n                ', tunable_type=RatingSubScore, default=RatingSubScore.MEDIUM, binary_type=EnumBinaryExportType.EnumUint32, export_modes=ExportModes.All), value_name='SubScoreData', value_type=TunableTuple(description='\n                Data about a sub score.\n                ', export_class_name='SubScoreDataTuple', name=TunableLocalizedString(description='\n                    The name of the sub score.\n                    ', export_modes=ExportModes.All), icon=TunableIcon(description='\n                    The icon for the sub score.\n                    ', export_modes=ExportModes.All)), tuple_name='SubScore', export_modes=ExportModes.All)}

