import sims4
from sims4.resources import Types
from sims4.tuning.tunable import TunableMapping, TunableEnumEntry, TunableReference, TunableTuple
import services
import tag

class EnvironmentScoreTuning:
    ENVIRONMENT_SCORE_BROADCASTER = TunableReference(description='\n        The singleton broadcaster that groups all scoring objects. The\n        constraints on this broadcaster determine the constraint within which a\n        Sim is affected by environment score.\n        ', manager=services.get_instance_manager(sims4.resources.Types.BROADCASTER), class_restrictions=('BroadcasterEnvironmentScore',))
    ENVIRONMENT_SCORE_MOODS = TunableMapping(description="\n        Tags on Objects correspond to a particular Mood.\n                \n        When an object is going to contribute to the environment score, put a\n        tag in it's catalog object, and make sure that tag points to a Mood\n        here.\n        ", key_type=TunableEnumEntry(description='\n            The Tag that corresponds to mood and environmental scoring data.\n            ', tunable_type=tag.Tag, default=tag.Tag.INVALID), value_type=TunableReference(description='\n            The mood that the Sim must be in for an object that emits this mood\n            to score. Corresponds to the mood_tag.\n            ', manager=services.get_instance_manager(sims4.resources.Types.MOOD), class_restrictions=('Mood',)), key_name='object_tag', value_name='mood')
    NEGATIVE_ENVIRONMENT_SCORING = TunableReference(description='\n        Defines the ranges and corresponding buffs to apply for negative\n        environmental contribution.\n        \n        Be sure to tune min, max, and the different states. The convergence\n        value is what will remove the buff. Suggested to be 0.\n        ', manager=services.get_instance_manager(sims4.resources.Types.STATISTIC), class_restrictions=('Commodity',))
    POSITIVE_ENVIRONMENT_SCORING = TunableReference(description='\n        Defines the ranges and corresponding buffs to apply for positive\n        environmental contribution.\n        \n        Be sure to tune min, max, and the different states. The convergence\n        value is what will remove the buff. Suggested to be 0.\n        ', manager=services.get_instance_manager(sims4.resources.Types.STATISTIC), class_restrictions=('Commodity',))
    BUILD_OBJECTS_ENVIRONMENT_SCORING = TunableTuple(description='\n        Defines the statistics which track the value of positive and negative\n        environmental contribution from build objects.\n        ', negative_environment_scoring=TunableReference(description='\n            Negative environmental statistic.\n            ', manager=services.get_instance_manager(Types.STATISTIC), class_restrictions=('Statistic',)), positive_environment_scoring=TunableReference(description='\n            Positive environmental statistic.\n            ', manager=services.get_instance_manager(Types.STATISTIC), class_restrictions=('Statistic',)))
    ENABLE_AFFORDANCE = TunableReference(description='\n        The interaction that will turn on Environment Score for a particular\n        object. This interaction should set a state on the object that will\n        have multipliers of 1 and adders of 0 for all moods.\n        ', manager=services.get_instance_manager(Types.INTERACTION))
    DISABLE_AFFORDANCE = TunableReference(description='\n        The interaction that will turn off Environment Score for a particular\n        object. This interaction should set a state on the object that will\n        have multipliers of 0 and adders of 0 for all moods.\n        ', manager=services.get_instance_manager(Types.INTERACTION))
    ENABLED_STATE_VALUE = TunableReference(description='\n        A state value that indicates the object should be contributing\n        Environment Score.\n        ', manager=services.get_instance_manager(sims4.resources.Types.OBJECT_STATE), class_restrictions=('ObjectStateValue',))
    DISABLED_STATE_VALUE = TunableReference(description='\n        A state value that indicates the object should not be contributing\n        Environment Score.\n        ', manager=services.get_instance_manager(sims4.resources.Types.OBJECT_STATE), class_restrictions=('ObjectStateValue',))

