import services
import sims4
from sims4.localization import TunableLocalizedStringFactory
from sims4.resources import CompoundTypes
from sims4.tuning.tunable import TunableReference, TunableList, TunableTuple, TunablePackSafeReference, Tunable, TunableResourceKey, TunablePackSafeResourceKey
from sims4.tuning.tunable_base import ExportModes

class BalanceSystemTuning:
    BALANCE_SYSTEM_COMMODITY = TunablePackSafeReference(description='\n        The commodity that tracks the current Balance System value for a given actor.\n        ', manager=services.get_instance_manager(sims4.resources.Types.STATISTIC), class_restrictions=('Commodity',), export_modes=ExportModes.ClientBinary)
    BALANCE_MAX_VALUE = Tunable(description='\n        The maximum value in which the Balance System Commodity is in the Balance state.\n        This should the the same as the maximum value of the Balance System Commodity.\n        ', tunable_type=float, default=100, export_modes=ExportModes.ClientBinary)
    BALANCE_MIN_VALUE = Tunable(description='\n        The minimum value in which the Balance System Commodity is in the Balance state.\n        ', tunable_type=float, default=50, export_modes=ExportModes.ClientBinary)
    MINOR_IMBALANCE_MIN_VALUE = Tunable(description='\n        The minimum value in which the Balance System Commodity is in the Minor Imbalance state.\n        ', tunable_type=float, default=-50, export_modes=ExportModes.ClientBinary)
    MAJOR_IMBALANCE_MIN_VALUE = Tunable(description='\n        The minimum value in which the Balance System Commodity is in the Major Imbalance state.\n        This should the the same as the minimum value of the Balance System Commodity.\n        ', tunable_type=float, default=-100, export_modes=ExportModes.ClientBinary)
    VISIBILITY_UI_DESCRIPTIONS = TunableList(description='\n        The possible descriptions in the visibility UI for the Balance System.\n        Descriptions are set when their associated buff is added to the actor.\n        If the buff is later removed from the actor without another Balance\n        System buff on the actor, the description will be set based on the\n        current state of the Balance System Commodity.\n        ', tunable=TunableTuple(buff_reference=TunableReference(description='\n                The buff associated with this description.\n                ', manager=services.get_instance_manager(sims4.resources.Types.BUFF), pack_safe=True, export_modes=ExportModes.ClientBinary), buff_description=TunableLocalizedStringFactory(description='\n                The description to show in the UI.\n                ', export_modes=ExportModes.ClientBinary), export_class_name='TunableVisibilityUIDescription'), export_modes=ExportModes.ClientBinary)

