from protocolbuffers.Localization_pb2 import LocalizedString
from objects.definition import Definition
from sims.sim_info import SimInfo
from sims4.localization import TunableLocalizedString
from sims4.tuning.instances import TunedInstanceMetaclass, TuningBlueprintBase
from sims4.tuning.tunable import TunableSet, TunableList, TunableReference, TunablePackSafeReference, Tunable, TunableBlock, TunableWallPattern, TunableRailing, TunableStairs, TunableCeilingRail, TunableFloorPattern, TunableFloorTrim, TunableRoofPattern, TunableRoofTrim, TunableStyle, TunableFence, TunableRoof, TunableFrieze, TunablePoolTrim, TunableHalfWallTrim, TunableHalfWall, TunableLotDescription, TunableCasPart, TunableBuildLadder
import services
import sims4.commands
interaction_manager = services.get_instance_manager(sims4.resources.Types.INTERACTION)
object_manager = services.definition_manager()

class Constants:

    class LocalizationStrings:
        CHIPS = TunableLocalizedString(description='UI Dialog option for fridge snack')
        COMEDY = TunableLocalizedString(description="UI dialog option for 'comedy' TV channel")
        FRENCH_TOAST = TunableLocalizedString(description="UI Dialog option for 'french toast' fridge crafting option")
        JUICE = TunableLocalizedString(description='UI Dialog option for one-handed potable fridge snack')
        JUICEDRINK2 = TunableLocalizedString(description='UI Dialog option for a specific juicedrink type drink crafting station option')
        MAKE_CHEESECAKE = TunableLocalizedString(description='Recipe interaction name for cheesecake')
        MAKE_FRENCH_TOAST = TunableLocalizedString(description='Recipe interaction name for french toast')
        MAKE_JUICEDRINK_GENERIC = TunableLocalizedString(description='Prototype name for make generic juice-type drink interaction from a crafting station')
        MAKE_JUICEDRINK2 = TunableLocalizedString(description='Recipe interaction name for a specific juicedrink-type drink that can be crafted')
        MAKE_ROAST_CHICKEN = TunableLocalizedString(description='Recipe interaction name for roast chicken')
        NAME_WITH_SIMOLEANS = TunableLocalizedString(description='Localization string used for interaction names with Simolean costs.')
        MASSAGE_THERAPIST = TunableLocalizedString(description="UI Dialog option for 'hire massage therapist'")
        ONE_HANDED_DRINK = TunableLocalizedString(description='\n            UI Dialog option for fridge snack.\n            A one-handed drink available to newly created families that is compatible with foods.')
        ONE_HANDED_SNACK = TunableLocalizedString(description='\n            UI Dialog option for fridge snack.\n            A one-handed food available to newly created families that is compatible with drinks.\n            Also pushes the eat at table interaction from the fridge.')
        ONE_TIME_MAID = TunableLocalizedString(description="UI Dialog option for 'one-time maid service'")
        PIZZA_DELIVERY = TunableLocalizedString(description="UI Dialog option for 'pizza delivery'")
        ROAST_CHICKEN = TunableLocalizedString(description="UI Dialog option for 'roast chicken' fridge crafting option")
        SIMCITY_CHEESECAKE = TunableLocalizedString(description="UI Dialog option for 'cheesecake' fridge crafting option")
        TOGETHER_MODIFIER = TunableLocalizedString(description="\n            Pie Menu Dialog modifier for doing a thing 'Together'.\n            For example, Go Here Together, or Jog Here Together")
        TRY_FOR_BABY = TunableLocalizedString(description='Pie menu dialog for try for baby')
        PAINT_PAINTING = TunableLocalizedString(description='Interaction name for painting')
        SMALL_CLASSIC_PAINTING = TunableLocalizedString(description='Pie menu name for classic painting')
        BREWED_COFFEE = TunableLocalizedString(description='Pie menu name for brew coffee')
        MICROWAVE_DINNER = TunableLocalizedString(description='Pie menu name microwave dinner')
        HAVE_A_QUICK_MEAL = TunableLocalizedString(description='Interaction name having microwave dinner')
        SHAPES = TunableLocalizedString(description='Pie menu name for drawing shapes at activity table')
        DRAW_SHAPES = TunableLocalizedString(description='Interaction name for drawing shapes at activity table')
        WALK = TunableLocalizedString(description='Interaction name for walk')

    class Interactions:
        ADOPT_SIM = TunableReference(manager=interaction_manager, description='computer interaction to adopt child')
        AGE_UP = TunableReference(manager=interaction_manager, description='age up baby to child')
        BARSTOOL_SIT = TunableReference(manager=interaction_manager, description='sit interaction on barstool setup lot object')
        BAR_MAKE_DRINK = TunableReference(manager=interaction_manager, description='interaction used for making drink at bar')
        BAR_MAKE_DRINK_STAGING = TunableReference(manager=interaction_manager, description='staging interaction used for making drink')
        BED_WOOHOO = TunableReference(manager=interaction_manager, description='woohoo interaction on bed')
        BOOK_READ = TunableReference(manager=interaction_manager, description='read book interaction')
        CHAT = TunableReference(manager=interaction_manager, description='\n            A supporting interaction that is usually present when two newly introduced sims are having a friendly conversation.\n            Used to verify that sims remain socializing for a short time period after that have been introduced. A test failure will be thrown\n            if the sim is not seen in this interaction a few moments after two sims begin a friendly conversation.\n            ')
        CHAT_HERE = TunableReference(manager=interaction_manager, description='terrain interaction used to make sims in a social go to a location')
        CHEAT_MAKESPOILED = TunableReference(manager=interaction_manager, description='cheat interaction to change the state of a food commodity to spoiled')
        CHEAT_REFILL = TunableReference(manager=interaction_manager, description='cheat interaction to refill a consumable, e.g. empty food plate')
        CLIMB_DOWN = TunableReference(manager=interaction_manager, description='climb down a ladder')
        CLIMB_UP = TunableReference(manager=interaction_manager, description='climb up a ladder')
        CLEAN_DISH_MICROWAVE = TunableReference(manager=interaction_manager, description='clean up interaction available on microwave object')
        CLEANOUT_SPOILEDFOOD_FROM_SIM = TunableReference(manager=interaction_manager, description="interaction used to clean out the spoiled food from sim's inventory")
        CLEANUP_DISH = TunableReference(manager=interaction_manager, description='clean up interaction on food plate/glass')
        COLLECT_TRASH = TunableReference(manager=interaction_manager, description='interaction used to collect trash from an indoor or outdoor trash can')
        COOK_GOURMET = TunableReference(manager=interaction_manager, description='fridge interaction that generates a dialog box for crafting options')
        COOK_HOMESTYLE = TunableReference(manager=interaction_manager, description='fridge interaction that generates a dialog box for crafting options')
        COMPLETE_HAZMAT_SUIT = TunablePackSafeReference(manager=interaction_manager, description='Interaction to combine an incomplete hazmat suit with spore filter to create a complete hazmat suit')
        CREATE_CRAFTABLES = TunableReference(manager=interaction_manager, description='Debug terrain interaction (shift+click) used to spawn craftable objects')
        DEAD_MANS_FLOAT = TunablePackSafeReference(manager=interaction_manager, description='interaction for performing a float in the water')
        DRINK_JUICEDRINK_GENERIC = TunableReference(manager=interaction_manager, description='interaction used for drinking juice-type drinks')
        EAT_CHIPS = TunableReference(manager=interaction_manager, description='interaction used for eating food')
        EAT_FRENCH_TOAST = TunableReference(manager=interaction_manager, description='interaction used for eating food')
        EMPTY_MICROWAVE = TunableReference(manager=interaction_manager, description='interaction used to empty the microwave object')
        EMPTY_OVEN = TunableReference(manager=interaction_manager, description='interaction used to empty the oven object')
        EAT_ROAST_CHICKEN = TunableReference(manager=interaction_manager, description='interaction used for eating food')
        EMPTY_TRASH = TunableReference(manager=interaction_manager, description='interaction used for emptying a trash can')
        FLY_DOWN = TunablePackSafeReference(manager=interaction_manager, description='fly down a ladder')
        FLY_UP = TunablePackSafeReference(manager=interaction_manager, description='fly up a ladder')
        FRIENDLY_SOCIAL = TunableList(TunableReference(manager=interaction_manager), description='Friendly social interactions, at least one of these should be available at any given time')
        GENERIC_BED_WOOHOO = TunableReference(manager=interaction_manager, description='woohoo interaction')
        GENERIC_COOK = TunableReference(manager=interaction_manager, description='interaction used for making food')
        GET_CASE_ASSIGNMENT = TunablePackSafeReference(manager=interaction_manager, description='interaction used for getting case assignment detective career')
        GIVE_INVESTIGATION_SYSTEM_INVENTORY_OBJECTS = TunablePackSafeReference(manager=interaction_manager, description="debug interaction used to fill Sim's inventory with objects they need for Strangerville storyline")
        GO_HERE = TunableReference(manager=interaction_manager, description='terrain interaction used to make sim go to a location')
        GO_ON_PATROL = TunablePackSafeReference(manager=interaction_manager, description='interaction used to go on patrol detective career')
        GRAB_A_SNACK = TunableReference(manager=interaction_manager, description='interaction used on fridge to generate basic food items')
        GRAB_ROAST_CHICKEN_PLATE = TunableReference(manager=interaction_manager, description='interaction used on a multiserving object to generate a single-serving object')
        HAVE_BABY = TunableReference(manager=interaction_manager, description='have baby triggered off labor buff')
        INTRODUCE = TunableReference(manager=interaction_manager, description='a friendly interaction that should be available even for two sims that do not know each other')
        KICK_OVER_OUTDOOR = TunableReference(manager=interaction_manager, description='interaction used for kicking an outdoor trash can')
        MAKE_FOOD_STAGING_BASIC = TunableReference(manager=interaction_manager, description='interaction used for making food')
        MAKE_FRENCH_TOAST = TunableReference(manager=interaction_manager, description='interaction used for making food')
        MAKE_ROAST_CHICKEN_COUNTER = TunableReference(manager=interaction_manager, description='interaction used for making food')
        NAP_SOFA = TunableReference(manager=interaction_manager, description='interaction on a sofa that satisfies energy motive')
        NAP_BED = TunableReference(manager=interaction_manager, description='interaction on a bed that satisfies energy motive')
        PHONE_PICK_SERVICE_TO_HIRE = TunableReference(manager=interaction_manager, description='Hire NPC service interaction on phone')
        PICKUP_OUTDOOR = TunableReference(manager=interaction_manager, description='interaction used to pickup an outdoor trash can that is lying in the ground after being kicked')
        PLACE_IN_WORLD = TunableReference(manager=interaction_manager, description='Interaction used on sim inventory objects to place object in world')
        PLAY_IN_TRASH_PILE = TunableReference(manager=interaction_manager, description='Interaction used for playing in a trash pile')
        PLAY_VIOLIN = TunableReference(manager=interaction_manager, description='Interaction used for playing the violin')
        PRACTICE_SPEAKING = TunableReference(manager=interaction_manager, description='Interaction used on a mirror object that solves for Social motive')
        PUT_AWAY = TunableReference(manager=interaction_manager, description="Interaction used on (non-sim) object to place object in object's inventory")
        PUT_IN_INVENTORY = TunableReference(manager=interaction_manager, description="Interaction used on object to place object in sim's inventory")
        REAPER_NOMORE_WORK = TunableReference(manager=interaction_manager, description='Interaction indicates that reaper has no more work after finalizing dead sim')
        REAPER_INSPECT = TunableReference(manager=interaction_manager, description='Interaction indicates that reaper has started inspecting the dead sim')
        RESET_OBJECT = TunableReference(manager=interaction_manager, description='Debug Interaction (shift+click) used to reset objects and sims')
        ROMANTIC_COMPLIMENT_APPEARANCE = TunableReference(manager=interaction_manager, description='Romantic -> Compliment Appearance Social interaction')
        ROMANTIC_MAKE_MOVE = TunableReference(manager=interaction_manager, description='Romantic -> Make Move Social interaction')
        RESET_OBJECT = TunableReference(manager=interaction_manager, description='Debug Interaction (shift+click) used to reset objects and sims')
        RUMMAGEFORFOOD_OUTDOOR = TunableReference(manager=interaction_manager, description='Interaction used to rummage for food from an outdoor trash can')
        SEALED_DOOR_EXAMINE = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to examine the sealed door in the Strangerville lab')
        SEALED_DOOR_USE_KEYCARD = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to use keycard to open the sealed door in the Strangerville lab')
        SET_FRONT_DOOR = TunableReference(manager=interaction_manager, description='Interaction used to set door as front door')
        SETUP_LOT = TunableReference(manager=interaction_manager, description='Debug terrain interaction (shift+click) used to spawn debug b/b objects')
        SIT_CHAIR = TunableReference(manager=interaction_manager, description='interaction used to make sim sit in a chair')
        SIT_PASSIVE = TunableReference(manager=interaction_manager, description='passive interaction used when sim is sitting')
        SLEEP_BED = TunableReference(manager=interaction_manager, description='interaction on a bed that solves for energy')
        STOMP_TRASH_PILE = TunableReference(manager=interaction_manager, description='interaction on a trash pile for stomping')
        TAKE_SHOWER = TunableReference(manager=interaction_manager, description='Interaction used on shower object that solves for hygeine motive')
        TODDLER_OCEAN_PLAY_GO_HERE = TunablePackSafeReference(manager=interaction_manager, description='User-directed interaction used on ocean to make toddler play in ocean')
        TODDLER_OCEAN_PLAY = TunablePackSafeReference(manager=interaction_manager, description='Continuation of TODDLER_OCEAN_PLAY_GO_HERE.')
        TRASH_SALVAGE_SCAVENGE = TunableReference(manager=interaction_manager, description='interaction used to salvage a trash pile')
        TRASHCAN_INDOOR_THROW_AWAY = TunableReference(manager=interaction_manager, description='Interaction used on an indoor trash can to throw away trash to an outdoor trash can')
        TRAVEL_CRIME_SCENE = TunablePackSafeReference(manager=interaction_manager, description='interaction used to travel to crime scene detective career')
        TURN_OFF_TV = TunableReference(manager=interaction_manager, description='Interaction used to turn off tv object')
        WASH_DISH = TunableReference(manager=interaction_manager, description='Interaction used to wash dirty dish object')
        WATCH_TV = TunableList(TunableReference(manager=interaction_manager), description='Interaction used on TV object that generates a dialogbox for channel options and solves for fun motive')
        UPGRADE_ALIEN_PORTAL = TunablePackSafeReference(manager=interaction_manager, description='interaction on invention constructor to upgrade alien portal')
        USE_TABLET = TunableReference(manager=interaction_manager, description='An interaction on tablets')
        USE_TOILET = TunableReference(manager=interaction_manager, description='Gender-nonspecfic interaction used on toilet object that solves for bladder motive')
        WATCH_COMEDY = TunableReference(manager=interaction_manager, description='interaction used for watching comedy on TV')
        WEAR_HAZMAT_SUIT = TunablePackSafeReference(manager=interaction_manager, description='interaction to put on completed hazmat suit')
        SWIM_HERE = TunableReference(manager=interaction_manager, description='terrain interaction used for sim to swim in pool')
        SWIM_HERE_OCEAN = TunablePackSafeReference(manager=interaction_manager, description='terrain interaction used for sim to swim in ocean')
        SIT_HERE = TunableReference(manager=interaction_manager, description='terrain interaction used to make sim sit at a location')
        TOILET_PREGNANCY_TEST = TunableReference(manager=interaction_manager, description='take pregnancy test on toilet object')
        TRAVEL_ALIEN_WORLD = TunablePackSafeReference(manager=interaction_manager, description='interaction used to travel to alien world')
        TRY_FOR_BABY = TunableReference(manager=interaction_manager, description='woohoo try-for-baby interaction')
        OBJECT_REPAIR = TunableReference(manager=interaction_manager, description='repair object interaction')
        FRIDGE_OF_STEEL = TunableReference(manager=interaction_manager, description='upgrade fridge to unbreakable interaction')
        REQUEST_TABLE = TunablePackSafeReference(manager=interaction_manager, description='request a table at a restaurant')
        PAY_BILL = TunablePackSafeReference(manager=interaction_manager, description='pay the bill at a restaurant and leave')
        RIGHT_THIS_WAY = TunablePackSafeReference(manager=interaction_manager, description='host leading sim to table')
        ORDER_FOOD_FOR_TABLE = TunablePackSafeReference(manager=interaction_manager, description='order food for table at a restaurant')
        WAIT_FOR_FOOD = TunablePackSafeReference(manager=interaction_manager, description='wait for ordered food to arrive at table')
        PET_SLEEP = TunablePackSafeReference(manager=interaction_manager, description='interaction for pet to find a preferred place and sleep')
        FILL_BOWL = TunablePackSafeReference(manager=interaction_manager, description='')
        SKATE_AROUND = TunablePackSafeReference(manager=interaction_manager, description='interaction to skate around')
        SKATE_GENERIC = TunablePackSafeReference(manager=interaction_manager, description='posture providing interaction to skate.')
        YELL_AT = TunablePackSafeReference(manager=interaction_manager, description='interaction to yell at another sim')
        FIGHT = TunablePackSafeReference(manager=interaction_manager, description='interaction to fight with another sim')
        DECLARE_ENEMY = TunablePackSafeReference(manager=interaction_manager, description='interaction to declare another sim as enemy')
        FIND_COMMON_GROUND = TunablePackSafeReference(manager=interaction_manager, description='interaction to find common ground with another sim')
        FIND_A_JOB = TunablePackSafeReference(manager=interaction_manager, description='interaction to find a job under work')
        SEARCH_DOCUMENTATION = TunablePackSafeReference(manager=interaction_manager, description='interaction to search the documentation')
        CRAFT_RESUME_COOK = TunablePackSafeReference(manager=interaction_manager, description='interaction to resume the food crafting')
        GRAB_A_SERVE = TunablePackSafeReference(manager=interaction_manager, description='interaction to grab a serving')
        SKIING_ONETIME_MEDIUM_INTENSITY = TunablePackSafeReference(manager=interaction_manager, description='interaction to skiing on easy lope snow')
        PURCHASE_OVERSIZED_CROP_SEEDS = TunablePackSafeReference(manager=interaction_manager, description='interaction to purchase oversized crop seeds')
        PLANT_OVERSIZED_CROP = TunablePackSafeReference(manager=interaction_manager, description='interaction to plant the oversized crop')
        WATERING_PLANTS = TunablePackSafeReference(manager=interaction_manager, description='interaction to watering the plants')
        TODDLERS_CARRY = TunableReference(description='\n            An interaction that requires the Sim to pick up a toddler.\n            ', manager=services.get_instance_manager(sims4.resources.Types.INTERACTION), class_restrictions=('SuperInteraction',))
        TODDLERS_BE_CARRIED = TunableReference(description='\n            The interaction that is pushed on toddlers that are being carried.\n            ', manager=services.get_instance_manager(sims4.resources.Types.INTERACTION), class_restrictions=('SuperInteraction',))
        TODDLERS_PUT_DOWN_SOFA = TunableReference(description='\n            An interaction that puts down carried toddlers on sofas.\n            ', manager=services.get_instance_manager(sims4.resources.Types.INTERACTION), class_restrictions=('SuperInteraction',))
        TODDLERS_USE_HIGH_CHAIR = TunableReference(description='\n            An interaction that requires the toddler to be picked up and put\n            down by an adult in order to use the high chair.\n            ', manager=services.get_instance_manager(sims4.resources.Types.INTERACTION), class_restrictions=('SuperInteraction',))
        TODDLERS_USE_BATHTUB = TunableReference(description='\n            An interaction that puts down carried toddlers in bathtubs and\n            tests out the toddlerBath multi-sim posture.\n            ', manager=services.get_instance_manager(sims4.resources.Types.INTERACTION), class_restrictions=('SuperInteraction',))
        PETS_DOG_WALK = TunablePackSafeReference(description='\n            An interaction that has a Sim leash up a dog.\n            ', manager=services.get_instance_manager(sims4.resources.Types.INTERACTION), class_restrictions=('SuperInteraction',))
        PETS_DOG_CARRY = TunablePackSafeReference(description='\n            An interaction that requires the Sim to pick up a dog.\n            ', manager=services.get_instance_manager(sims4.resources.Types.INTERACTION), class_restrictions=('SuperInteraction',))
        PETS_DOG_PUT_DOWN_ON_SURFACE = TunablePackSafeReference(description='\n            An interaction that puts a dog down on a routable surface.\n            ', manager=services.get_instance_manager(sims4.resources.Types.INTERACTION), class_restrictions=('SuperInteraction',))
        PETS_DOG_SOCIALIZE = TunablePackSafeReference(description='\n            An social interaction supporting multiple dogs.\n            ', manager=services.get_instance_manager(sims4.resources.Types.INTERACTION), class_restrictions=('SocialSuperInteraction',))
        INFANTS_CARRY = TunableReference(manager=interaction_manager, description='An interaction that requires the Sim to pick up an infant and carry at front.')
        INFANTS_BE_CARRIED = TunableReference(manager=interaction_manager, description='The interaction that is pushed on infants that are being carried.')
        INFANTS_CARRY_FRONT_TO_BACK = TunablePackSafeReference(manager=interaction_manager, description='The interaction to transfer the infant from front carry to back carry.')
        INFANTS_CARRY_BACK_TO_FRONT = TunablePackSafeReference(manager=interaction_manager, description='The interaction to transfer the infant from back carry to front carry.')
        INFANTS_CHANGE_DIAPER_ON_STATION = TunablePackSafeReference(manager=interaction_manager, description='Change Infant Diaper picker interaction on the changing station.')
        INFANTS_GET_DIAPER_CHANGED = TunablePackSafeReference(manager=interaction_manager, description='The interaction on infants when their diaper is being changed on the changing station.')
        INFANTS_LAY_ON_BACK_CRIB = TunableReference(manager=interaction_manager, description='The interaction on infants when they are laying on back in crib.')
        STAND = TunableReference(manager=interaction_manager, description='Stand posture provider')
        SIT = TunableReference(manager=interaction_manager, description='Sit posture provider')
        SIT_INTIMATE = TunableReference(manager=interaction_manager, description='Sit intimate posture provider')
        SIT_BED_KNEEL = TunablePackSafeReference(manager=interaction_manager, description='Sit kneeling on bed posture provider')
        SIT_BED_CROSSLEGGED = TunablePackSafeReference(manager=interaction_manager, description='Sit cross-legged on bed posture provider')
        SIT_INTIMATE_BOOTH = TunableReference(manager=interaction_manager, description='Sit intimate for booths/sectional sofa.')
        SWIM = TunableReference(manager=interaction_manager, description='Swim posture provider')
        DOG_STAND = TunablePackSafeReference(manager=interaction_manager, description='Dog stand posture provider')
        DOG_SWIM = TunablePackSafeReference(manager=interaction_manager, description='Dog Swim posture provider')
        CARRY_HOLD_OBJECT = TunableReference(manager=interaction_manager, description='Interaction run when holding an object')
        PAINTING_SELL = TunableReference(manager=interaction_manager, description='Interaction to sell the painting')
        PAINTING_SELL_ART_GALLERY = TunableReference(manager=interaction_manager, description='Interaction to sell the painting to art gallery')
        EASEL_PAINTING_STAGING_SMALL = TunableReference(manager=interaction_manager, description='Crafting staging interaction for painting small painting at the easel')
        CRAFTING_RESUME_EASEL = TunableReference(manager=interaction_manager, description='Interaction to resume crafting at the easel')
        WAIT_FOR_POT = TunableReference(manager=interaction_manager, description='Coffee maker interaction while waiting for pot to brew')
        MICROWAVE_STAGING_BASIC = TunableReference(manager=interaction_manager, description='Crafting staging interaction for microwaving dinner')
        COMPUTER_BROWSE_WEB = TunableReference(manager=interaction_manager, description='Interaction for browsing the web on the computer')
        ACTIVITY_TABLE_CRAFT_PICTURE_STAGING = TunableReference(manager=interaction_manager, description='Crafting staging interaction for activity table')
        CRAFTING_RESUME_ACTIVITY_TABLE = TunableReference(manager=interaction_manager, description='Interaction to resume crafting at the activity table')
        PETS_CAT_SIT = TunablePackSafeReference(manager=interaction_manager, description='Interaction for cat to sit.')
        PETS_BRING_BALL = TunablePackSafeReference(manager=interaction_manager, description='Interaction to command pet to fetch ball, requires trait_pets_training_command_fetch.')
        MAKE_SIM_FAIRY = TunablePackSafeReference(manager=interaction_manager, description='Interaction to make the Sim a fairy.')
        CHANGE_TO_FAIRY_FORM = TunablePackSafeReference(manager=interaction_manager, description='Interaction to change the Sim into the fairy occult form.')
        CHANGE_FROM_FAIRY_FORM = TunablePackSafeReference(manager=interaction_manager, description='Interaction to change the Sim out of the fairy occult form.')
        CARRY_WINGS = TunablePackSafeReference(manager=interaction_manager, description='Interaction run when a fairy is holding their wings')
        VET_SIGN_IN_FOR_SICKNESS = TunablePackSafeReference(manager=interaction_manager, description='Interaction to sign in for sickness.')
        VET_PET_EXAMINE_SUPER = TunablePackSafeReference(manager=interaction_manager, description='Super interaction for vet exam as pet.')
        VET_GREET_PET = TunablePackSafeReference(manager=interaction_manager, description='Interaction to greet the pet.')
        VET_GREET_PET_OWNER = TunablePackSafeReference(manager=interaction_manager, description='Interaction to greet the pet owner.')
        VET_EXAMINE_SUPER = TunablePackSafeReference(manager=interaction_manager, description='Super interaction for vet exam.')
        VET_EXAMINATION_1 = TunablePackSafeReference(manager=interaction_manager, description='Examination 1 to run on pet.')
        VET_EXAMINATION_2 = TunablePackSafeReference(manager=interaction_manager, description='Examination 2 to run on pet.')
        VET_CALM_PET = TunablePackSafeReference(manager=interaction_manager, description='Calm pet interaction.')
        VET_INCORRECT_TREATMENT = TunablePackSafeReference(manager=interaction_manager, description='Interaction to treat the pet incorrectly.')
        VET_CORRECT_TREATMENT = TunablePackSafeReference(manager=interaction_manager, description='Interaction to treat the pet.')
        VET_PET_BILL_OWNER = TunablePackSafeReference(manager=interaction_manager, description='Interaction to bill the pet owner.')
        VET_BILL_OWNER = TunablePackSafeReference(manager=interaction_manager, description='Interaction to bill the pet owner.')
        CREATE_CARRY_UMBRELLA = TunablePackSafeReference(manager=interaction_manager, description='Interaction that is run when sim is holding an umbrella.')
        PICK_UMBRELLA = TunablePackSafeReference(manager=interaction_manager, description='Interaction that is run for sim to pick an umbrella.')
        VET_GREET_PET_NEUTRAL = TunablePackSafeReference(manager=interaction_manager, description='Interaction to greet the pet in neutral.')
        VET_GREET_PET_OWNER_NEUTRAL = TunablePackSafeReference(manager=interaction_manager, description='Interaction to greet the pet owner in neutral.')
        VET_BEGIN_EXAMINING = TunablePackSafeReference(manager=interaction_manager, description='Interaction to begin the pet examine.')
        VET_EXAMINE_CALM_PET = TunablePackSafeReference(manager=interaction_manager, description='Interaction to calm pet.')
        VET_EXAMINE_MOUTH = TunablePackSafeReference(manager=interaction_manager, description='Interaction to examine pet mouth.')
        VET_EXAMINE_SKINFURINSPECTION = TunablePackSafeReference(manager=interaction_manager, description='Interaction to examine pet skin and fur.')
        VET_EXAMINE_TESTEARS = TunablePackSafeReference(manager=interaction_manager, description='Interaction to examine pet ears.')
        VET_EXAMINE_EYEEXAM = TunablePackSafeReference(manager=interaction_manager, description='Interaction to examine pet eyes.')
        VET_EXAMINE_LISTENTOHEART = TunablePackSafeReference(manager=interaction_manager, description='Interaction to examine pet heart.')
        VET_EXAMINE_LISTENTOBREATHING = TunablePackSafeReference(manager=interaction_manager, description='Interaction to examine pet breathing.')
        VET_EXAMINE_END = TunablePackSafeReference(manager=interaction_manager, description='Interaction to end pet examine.')
        RETAIL_SET_ITEM_FOR_SALE = TunablePackSafeReference(manager=interaction_manager, description='Interaction to mark objects for sale')
        RETAIL_CLOCK_IN = TunablePackSafeReference(manager=interaction_manager, description='Interaction employee uses to clock in')
        RETAIL_INSTRUCT_TO_CHECK_OUT = TunablePackSafeReference(manager=interaction_manager, description='Interaction to instruct employee to check out customers')
        RETAIL_CHECK_OUT_CUSTOMER = TunablePackSafeReference(manager=interaction_manager, description='Interaction to check out customer')
        RABBIT_HOLE_TEST = TunablePackSafeReference(manager=interaction_manager, description='Interaction that tests rabbit hole constraint')
        SIT_ON_VACUUM = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to make a cat sim sit on a robot vacuum')
        RETURN_TO_DOCK = TunablePackSafeReference(manager=interaction_manager, description='interaction used to command robot vacuum object to return to dock')
        RIDE_HERE = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to get sim to ride the water scooter to a location.')
        WATER_SCOOTER_MOBILE_POSTURE = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to get sim to verify that sim is in the water scooter mobile posture.')
        CANOE_BOARD = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to get sim to board island canoe.')
        CANOE_SAIL_HERE = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to get sim to sail to a location with an island canoe.')
        CANOE_LOUNGE = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to get sim to lounge on an island canoe.')
        CANOE_GO_FISHING = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to get sim to go fishing on the island canoe.')
        CANOE_MOBILE_POSTURE = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to get sim to verify that sim is in the island canoe mobile posture.')
        CANOE_SIT_POSTURE = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to get sim to verify that sim is in the island canoe sit posture.')
        CANOE_PLACE_IN_WORLD = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to get the canoe out of the inventory.')
        CANOE_EXIT = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to get the sim out of the canoe.')
        BICYCLE_POSTURE_INTERACTION = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to verify the Sim mounted the bicycle after travel.')
        BICYCLE_TRAVEL = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to travel on the bicycle.')
        BIKE_GO_HERE = TunablePackSafeReference(manager=interaction_manager, description='Terrain interaction for biking')
        BUY_CURIO_ITEMS = TunablePackSafeReference(manager=interaction_manager, description='Interaction to buy curio items.')
        SPELL_DEBUG_UNLOCK = TunablePackSafeReference(manager=interaction_manager, description='Debug interaction to unlock spells.')
        SPELL_CAST_TOGGLE_WAND = TunablePackSafeReference(manager=interaction_manager, description='Interaction to toggling using wands for spells.')
        SPELL_CAST_FREEZE_SIM = TunablePackSafeReference(manager=interaction_manager, description='Interaction to cast freeze Sim spell.')
        SPELL_CAST_CLONE_SELF = TunablePackSafeReference(manager=interaction_manager, description='Interaction to cast clone self spell.')
        SPELL_CAST_CLEAN_SELF = TunablePackSafeReference(manager=interaction_manager, description='Interaction to cast clean self spell.')
        SPELL_CAST_TERRAIN_TELEPORT = TunablePackSafeReference(manager=interaction_manager, description='Interaction to cast world teleport spell.')
        BROOMSTICK_FLY_HERE = TunablePackSafeReference(manager=interaction_manager, description='Interaction to perform user directed broom teleport.')
        FAMILIAR_BIND = TunablePackSafeReference(manager=interaction_manager, description='Interaction to bind familiar.')
        FAMILIAR_SUMMON = TunablePackSafeReference(manager=interaction_manager, description='Interaction to summon familiar.')
        FAMILIAR_UNBIND = TunablePackSafeReference(manager=interaction_manager, description='Interaction to unbind familiar.')
        BICYCLE_TRAVEL = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to travel on the bicycle.')
        ACTIVATE_ALL_BOTS = TunablePackSafeReference(manager=interaction_manager, description='Interaction to activate all bots.')
        VOTE_CIVIC_POLICY = TunablePackSafeReference(manager=interaction_manager, description='interaction to vote on neighborhood action plans')
        START_SKIING = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to start skiing.')
        SKI_DOWNHILL = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to ski downhill.')
        SLED_TOGETHER_SIM_PICKER = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to sled together with others.')
        START_SLED_TOGETHER = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to start sledding together.')
        SLOPE_MOVE_AWAY = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to move away from slope.')
        START_SKIING_ONETIME = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to start skiing one time.')
        START_SKIING_ONETIME_LOW = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to start skiing one time low.')
        ALIEN_DISGUISE_SELF = TunablePackSafeReference(manager=interaction_manager, description='Interaction to wear alien disguise.')
        ALIEN_REMOVE_DISGUISE = TunablePackSafeReference(manager=interaction_manager, description='Interaction to remove alien disguise.')
        VAMPIRE_TELEPORT = TunablePackSafeReference(manager=interaction_manager, description='Interaction to perform vampire mist teleport.')
        WEDDING_AISLE_SEND_PAIR_DOWN = TunablePackSafeReference(manager=interaction_manager, description='Interaction to send two sims down wedding aisle.')
        WEDDING_AISLE_WALK_TOGETHER = TunablePackSafeReference(manager=interaction_manager, description='Interaction of two sims walking down wedding aisle.')
        WEREWOLF_MAX_FURY = TunablePackSafeReference(manager=interaction_manager, description='Interaction to grant max fury to a werewolf.')
        GET_CLASS_LIST = TunablePackSafeReference(manager=interaction_manager, description='Interaction to get class list.')
        BRING_INFANT_INSIDE = TunablePackSafeReference(manager=interaction_manager, description='Interaction to bring infant inside.')
        HAND_INFANT_TO_SIM = TunablePackSafeReference(manager=interaction_manager, description='Interaction to hand infant to another sim.')
        PUT_INFANT_DOWN = TunablePackSafeReference(manager=interaction_manager, description='Interaction to bring request infant be put down.')
        CHANGE_INFANT_OUTFIT = TunablePackSafeReference(manager=interaction_manager, description='Interaction used to change infant outfit using changing table')

    class ObjectDefinitions:
        ALIEN_PORTAL = TunablePackSafeReference(manager=object_manager, description='Portal to alien world')
        AUTOTEST_CHIPS = TunableReference(manager=object_manager, description='long to eat debug chips used by autotests')
        BAKE_PAN = TunableReference(manager=object_manager, description='a food baking pan block model object slots into stove')
        BAR = TunableReference(manager=object_manager, description='bar created by setup lot cheat')
        BATHTUB = TunableReference(manager=object_manager, description='bathtub created in the toddlerTest portion of GUISmoke')
        BOOK = TunableReference(manager=object_manager, description='individual book object')
        CAKE_BAKE_PAN = TunableReference(manager=object_manager, description='a cake baking pan object created during make_cheesecake interaction')
        CHAIR = TunableReference(manager=object_manager, description='Seat object created by setup lot cheat, 4 of these are placed around the dining table')
        CHANGING_STATION = TunablePackSafeReference(manager=object_manager, description='Changing station used for infants')
        CHEESECAKE = TunableReference(manager=object_manager, description='edible craftable object')
        CHIPS = TunableReference(manager=object_manager, description='edible object that can be placed in the world')
        COMPLETED_HAZMAT_SUIT = TunablePackSafeReference(manager=object_manager, description="A completed Hazmat suit that lives in Sim's inventory and is used for traveling through spore clouds")
        COUNTER = TunableReference(manager=object_manager, description='created by setup lot cheat')
        CRIB = TunableReference(manager=object_manager, description='crib used for infants.')
        DECO_LARGE_SLOT = TunableReference(manager=object_manager, description='A decorative object requiring a large slot')
        DECO_MEDIUM_SLOT = TunableReference(manager=object_manager, description='A decorative object requiring a medium slot')
        DECO_SMALL_SLOT = TunableReference(manager=object_manager, description='A decorative object requiring a small slot')
        DIRTY_DISH = TunableReference(manager=object_manager, description='Dirty dish object generated when cleaning out spoiled food')
        DOOR = TunableReference(manager=object_manager, description='wall-placable object that creates a portal allowing sim to walk through the wall')
        DOUBLE_BED = TunableReference(manager=object_manager, description='energy-fulfilling woohoo-compatible object created by setup lot cheat')
        DUCKS = TunablePackSafeReference(manager=object_manager, description='A water-placeable duck')
        EMPTY_GLASS = TunableReference(manager=object_manager, description='A drinking tumbler object that is empty')
        FRENCH_TOAST = TunableReference(manager=object_manager, description='edible single-serving craftable object')
        FRIDGE = TunableReference(manager=object_manager, description='food storage device created by setup lot cheat')
        FRY_PAN = TunableReference(manager=object_manager, description='a food fry pan block model object slots onto stove')
        HIGH_CHAIR = TunableReference(manager=object_manager, description='A high chair, where toddlers sit and eat')
        HIGH_WALL_PAINTING = TunableReference(manager=object_manager, description='a painting that can be height adjusted on a wall')
        INDOOR_TRASHCAN = TunableReference(manager=object_manager, description='an indoor trash can object')
        INCOMPLETE_HAZMAT_SUIT = TunablePackSafeReference(manager=object_manager, description="An incomplete Hazmat suit that lives in Sim's inventory that, when completed, is used for traveling through spore clouds")
        INVENTION_CONSTRUCTOR = TunablePackSafeReference(manager=object_manager, description='Scientist object')
        JUICE = TunableReference(manager=object_manager, description='JuiceDrink-type cheat-spawnable craftable object compatible with sim inventory and fridge inventory')
        JUICEDRINK2 = TunableReference(manager=object_manager, description='JuiceDrink-type crafted object, requires bartending skill to create, craftable at bar')
        MASSAGE_TABLE = TunablePackSafeReference(manager=object_manager, description='the relaxer massage table')
        MICROWAVE = TunableReference(manager=object_manager, description='A Schmapple microwave object')
        MICROWAVE_DINNER = TunableReference(manager=object_manager, description='A food plate object created by cooking a microwave dinner')
        MIRROR_FLOOR = TunableReference(manager=object_manager, description='mirror created by setup lot cheat, placed on the floor')
        MIRROR_WALL = TunableReference(manager=object_manager, description='mirror that can be hung on a wall')
        OUTDOOR_TRASHCAN = TunableReference(manager=object_manager, description='An outdoor trash can')
        PICNIC_TABLE = TunableReference(manager=object_manager, description='Picnic table object used in posture graph test')
        POLICE_STATION_COMPUTER = TunablePackSafeReference(manager=object_manager, description='A computer found at the police station')
        REED = TunablePackSafeReference(manager=object_manager, description='A reed object that can be placed on water')
        ROAST_CHICKEN = TunableReference(manager=object_manager, description='edible multiserving object, spawns single-serving objects')
        ROAST_CHICKEN_PLATE = TunableReference(manager=object_manager, description='edible single-serving craftable object')
        ROAST_CHICKEN_TRAY = TunableReference(manager=object_manager, description='transitional craftable object')
        ROBOT_VACUUM = TunablePackSafeReference(manager=object_manager, description='Robot vacuum object')
        ROBOT_VACUUM_DOCK = TunablePackSafeReference(manager=object_manager, description='Dock for robot vacuum object')
        RUMMAGED_MACNCHEESE_FOODPLATE = TunableReference(manager=object_manager, description='mac n cheese foodplate created by rummage interaction on outdoor trash can')
        RUMMAGED_OATMEAL_FOODPLATE = TunableReference(manager=object_manager, description='oatmeal foodplate created by rummage interaction on outdoor trash can')
        RUMMAGED_SALADGARDEN_FOODPLATE = TunableReference(manager=object_manager, description='salad garden foodplate created by rummage interaction on outdoor trash can')
        SCYTHE = TunableReference(manager=object_manager, description="Death's scythe")
        SEALED_DOOR = TunablePackSafeReference(manager=object_manager, description='The sealed door in entrance of lab in Strangerville')
        SEALED_DOOR_2 = TunablePackSafeReference(manager=object_manager, description='The 2nd sealed door in the Strangerville lab')
        SEALED_DOOR_3 = TunablePackSafeReference(manager=object_manager, description='The 3rd sealed door in the Strangerville lab')
        SEARCH_EVIDENCE = TunablePackSafeReference(manager=object_manager, description='The first evidence in Strangerville lab')
        SHOWER = TunableReference(manager=object_manager, description='Hygeine-fulfilling object created by setup lot cheat')
        SINK = TunableReference(manager=object_manager, description='Bathroom sink object created by setup lot cheat')
        SOFA = TunableReference(manager=object_manager, description='Multi-seat seatable object created by setup lot cheat')
        STOOL = TunableReference(manager=object_manager, description='Single-seat object created by setup lot cheat')
        STOVE = TunableReference(manager=object_manager, description='a stove object created by the setup lot cheat')
        TABLE = TunableReference(manager=object_manager, description='Dining table object created by setup lot cheat')
        TABLE_SMALL_SLOT = TunableReference(manager=object_manager, description='A table with a small slot')
        TOILET = TunableReference(manager=object_manager, description='Bladder-fulfilling seatable object created by setup lot cheat')
        TOMBSTONE = TunableReference(manager=object_manager, description='A tombstone for a dead sim')
        TRASH_PILE = TunableReference(manager=object_manager, description='A trash pile')
        TRASH_PILE_SCAVENGE = TunableReference(manager=object_manager, description='A trash pile that can be scavenged for parts')
        TV = TunableReference(manager=object_manager, description='Entertainment-fulfilling chair-compatible object created by setup lot cheat')
        URN = TunableReference(manager=object_manager, description='An urn holding the ashes of a dead sim')
        WALL_LIGHT = TunableReference(manager=object_manager, description='A wall sconce light')
        POOL_WALL_LIGHT = TunableReference(manager=object_manager, description='A pool wall light')
        POOL_FLOOR_LIGHT = TunableReference(manager=object_manager, description='A pool floor light')
        POOL_LADDER = TunableReference(manager=object_manager, description='A pool ladder')
        COUNTER_ISLE = TunableReference(manager=object_manager, description='A isle counter different from counter defined in COUNTER')
        CEILING_LIGHT = TunableReference(manager=object_manager, description='A ceiling light')
        FRIDGE2 = TunableReference(manager=object_manager, description='food storage device in sqe gameplay world')
        BASSINET = TunableReference(manager=object_manager, description='baby birthing pod')
        KITCHEN_UPGRADE_PART = TunableReference(manager=object_manager, description='kitchen upgrade part')
        COMMON_UPGRADE_PART = TunableReference(manager=object_manager, description='common upgrade part')
        HOST_STATION = TunablePackSafeReference(manager=object_manager, description='host station used in restaurant test')
        SQUARE_TABLE = TunableReference(manager=object_manager, description='square table used for pets tests')
        BOOMBOX = TunableReference(manager=object_manager, description='boombox used to pets tests')
        PET_BOWL = TunablePackSafeReference(manager=object_manager, description='food bowl for pets tests')
        VET_PODIUM = TunablePackSafeReference(manager=object_manager, description='vet podium')
        SKATING_RINK = TunablePackSafeReference(manager=object_manager, description='skating rink')
        UMBRELLA_RACK = TunablePackSafeReference(manager=object_manager, description='Umbrella rack for sims to use umbrella.')
        UMBRELLA = TunablePackSafeReference(manager=object_manager, description='Used to verify that sim will carry umbrella in the rain.')
        EP10_EASY_SLOPE_SNOW = TunablePackSafeReference(manager=object_manager, description='Used to skiing when sim is in mountain climb excursion.')
        STRANGEVILLE_CURIO_SHOP = TunablePackSafeReference(manager=object_manager, description='Curio shop to buy items')
        STRANGEVILLE_SPY_BUG = TunablePackSafeReference(manager=object_manager, description='Used to plant on other sims to spy.')
        GARDENPLANT_PATCH = TunablePackSafeReference(manager=object_manager, description='A place to crop the plants')
        OVERSIZED_PUMPKIN_SEEDS = TunablePackSafeReference(manager=object_manager, description='Oversized pumpkin seeds')
        EASEL = TunableReference(manager=object_manager, description='an easel for painting')
        PAINT_CANVAS = TunableReference(manager=object_manager, description='canvas generated from painting')
        COFFEE_MAKER = TunableReference(manager=object_manager, description='a coffee maker')
        COMPUTER = TunableReference(manager=object_manager, description='a computer')
        DESK = TunableReference(manager=object_manager, description='a desk')
        ACTIVITY_TABLE = TunableReference(manager=object_manager, description='an activity table')
        CRAFT_PICTURE = TunableReference(manager=object_manager, description='picture generated from activity table')
        TOYBOX = TunableReference(manager=object_manager, description='a toybox')
        CAT_CONDO = TunablePackSafeReference(manager=object_manager, description='a high end cat condo with lots of places for cat to sit')
        PET_BALL = TunablePackSafeReference(manager=object_manager, description='a pet ball')
        TABLET = TunableReference(manager=object_manager, description='an electronic tablet')
        VIOLIN = TunableReference(manager=object_manager, description='a portable musical instrument')
        WATER_SCOOTER = TunablePackSafeReference(manager=object_manager, description='Water scooter used for testing ocean vehicles.')
        ISLAND_CANOE = TunablePackSafeReference(manager=object_manager, description='Island canoe used for testing ocean vehicles.')
        BICYCLE_DEFINITION = TunablePackSafeReference(manager=object_manager, description='Bicycle used for testing vehicle travel.')
        BOT_CLEAN = TunablePackSafeReference(manager=object_manager, description='Cleaning Bot.')
        BOT_GARDEN = TunablePackSafeReference(manager=object_manager, description='Gardening Bot.')
        BOT_PARTY = TunablePackSafeReference(manager=object_manager, description='Party Bot.')
        BOT_REPAIR = TunablePackSafeReference(manager=object_manager, description='Repair Bot')
        COMMUNITY_VOTING_BOARD = TunablePackSafeReference(manager=object_manager, description='Community Voting Board')
        BOT_TESTS_COUNTER = TunablePackSafeReference(manager=object_manager, description='Counter')
        BOT_TESTS_SINK1 = TunablePackSafeReference(manager=object_manager, description='Sink 1')
        BOT_TESTS_SINK2 = TunablePackSafeReference(manager=object_manager, description='Sink 2')
        BOT_TESTS_PLANTER = TunablePackSafeReference(manager=object_manager, description='Planter Box')
        BOT_TESTS_PLANT = TunablePackSafeReference(manager=object_manager, description='Tomator Plant')
        EASY_SLOPE = TunablePackSafeReference(manager=object_manager, description='Easy Slope')
        BUNNY_SLOPE = TunablePackSafeReference(manager=object_manager, description='Bunny Slope')
        PET_EXAMINE_TABLE1 = TunablePackSafeReference(manager=object_manager, description='Pet Examine Table')
        PET_EXAMINE_TABLE2 = TunablePackSafeReference(manager=object_manager, description='Pet Examine Table')
        SECTIONAL_SOFA = TunableReference(manager=object_manager, description='Sectional Sofa dynamically configured gameplay object')
        SECTIONAL_SOFA_PIECE = TunablePackSafeReference(manager=object_manager, description='Sectional Sofa piece, placed by B/B')
        MAGIC_WAND = TunablePackSafeReference(manager=object_manager, description='Magic wand to use when casting spells')
        MAGIC_BROOM = TunablePackSafeReference(manager=object_manager, description='Broomstick to use for broom teleport')
        MAGIC_FAMILIAR = TunablePackSafeReference(manager=object_manager, description='Familiar summoned')
        PETAL_LINED_WEDDING_AISLE_SHORT = TunablePackSafeReference(manager=object_manager, description='Wedding aisle')

    class ResourceIds:
        BLK_FENCE_AND_CEILING_RAIL = TunableBlock(description='Build/buy block product type, has fence railing wall facet types and ceiling friezes')
        BLK_HEXAGON_3x3 = TunableBlock(description='Build/buy block product type, hexagonal 3x3 block with diagonal walls on the corners')
        BLK_L_SHAPE = TunableBlock(description='L-shaped block used for build/buy block placement and manipulation tests')
        BLK_RIGHT_ROUNDED_3x5 = TunableBlock(description='3x5 block with a flat left side and rounded right side, with a single unit wide non-rounded wall segment between the two rounded sides')
        BLK_ROUNDED_LARGE = TunableBlock(description='7x7 rounded deck')
        BLK_ROUNDED_SMALL = TunableBlock(description='3x3 rounded deck')
        BLK_SQUARE_DECK = TunableBlock(description='Build/buy block product type, outdoor block with fence railing wall facet types')
        BLK_SQUARE_ROOM_3x3 = TunableBlock(description='Build/Buy block product type, 3x3 plain square block with no automatic doors or windows')
        BLK_TRIANGLE_TR_2x2 = TunableBlock(description='Build/Buy block product type, 2x2 block with flat left and bottom sides and a diagonal top-right side')
        DROP_WALL_PRODUCT1 = TunableWallPattern(description='Generic stair drop wall product used for build/buy tests')
        DROP_WALL_PRODUCT2 = TunableWallPattern(description='Generic stair drop wall type, should be disctinct from DROP_WALL_PRODUCT1')
        RAILING_PRODUCT1 = TunableRailing(description='Generic stair railing type used for build/buy tests')
        RAILING_PRODUCT2 = TunableRailing(description='Generic stair railing type, should be distinct from railing defined in RAILING_PRODUCT1')
        ROOF_PATTERN_DEFAULT = TunableRoof(description='Roof pattern used for build/buy tests')
        STAIR_PRODUCT1 = TunableStairs(description='Generic stair type used for stair functionality testing')
        STAIR_PRODUCT2 = TunableStairs(description='Generic stair type, visually distinct from STAIR_PRODUCT1')
        STYLE1 = TunableStyle(description='Build/buy style used to verify stlye change functionality. Should be different from style defined in STYLE2')
        STYLE1_FENCE_TYPE = TunableFence(description='fence type used by style defined in STYLE1')
        STYLE1_INNER_WALL_PATTERN = TunableWallPattern(description='inner wall pattern used by style defined in STYLE1')
        STYLE1_OUTER_WALL_PATTERN = TunableWallPattern(description='outer wall pattern used by style defined in STYLE1')
        STYLE2 = TunableStyle(description='Build/buy style used to verify stlye change functionality. Should be different from style defined in STYLE1')
        STYLE2_INNER_WALL_PATTERN = TunableWallPattern(description='inner wall pattern used by style defined in STYLE2')
        STYLE2_OUTER_WALL_PATTERN = TunableWallPattern(description='outer wall pattern used by style defined in STYLE2')
        FRIEZE_PRODUCT1 = TunableFrieze(description='frieze product used by STYLE1')
        FRIEZE_PRODUCT2 = TunableFrieze(description='frieze product different from product defined in STYLE1')
        FENCE_TYPE2 = TunableFence(description='fence type different from type defined in STYLE1')
        INNER_WALL_PATTERN2 = TunableWallPattern(description='inner wall pattern different from pattern defined in STYLE1')
        OUTER_WALL_PATTERN2 = TunableWallPattern(description='outer wall pattern different from pattern defined in STYLE1')
        CEILING_RAIL2 = TunableCeilingRail(description='ceiling rail different from product defined in STYLE1')
        DECK_FLOOR_PATTERN2 = TunableFloorPattern(description='deck floor pattern different from pattern defined in STYLE1')
        INNER_FLOOR_PATTERN2 = TunableFloorPattern(description='inner floor pattern different from pattern defined in STYLE1')
        FLOOR_TRIM2 = TunableFloorTrim(description='floor trim different from trim defined in STYLE1')
        ROOF_TRIM2 = TunableRoofTrim(description='roof eave trim different from trim defined in STYLE1')
        ROOF_PATTERN2 = TunableRoofPattern(description='Roof pattern different from pattern defined in STYLE1')
        POOL_DIAG_SQUARE_1x1 = TunableBlock(description='Build/buy block product type, diagonal 1x1 pool block')
        POOL_OCTAGON_3x3 = TunableBlock(description='Build/buy block product type, octagon 3x3 pool block')
        POOL_SQUARE_1x1 = TunableBlock(description='Build/buy block product type, square 1x1 pool block')
        POOL_TRIANGLE_1x1 = TunableBlock(description='Build/buy block product type, triangle 1x1 pool block')
        POOL_TRIM2 = TunablePoolTrim(description='pool trim different from trim defined in STYLE1')
        HALF_WALL1 = TunableHalfWall(description='Generic halfwall type')
        HALF_WALL2 = TunableHalfWall(description='Generic halfwall type different from type defined in HALF_WALL1')
        HALF_WALL_TRIM = TunableHalfWallTrim(description='Half wall trim different from default one')
        WALL_PATTERN = TunableWallPattern(description='wall pattern different from pattern defined in STYLE1 and STYLE2')
        WALL_PATTERN_1 = TunableWallPattern(description='additional wall pattern')
        WALL_PATTERN_2 = TunableWallPattern(description='additional wall pattern')
        WALL_PATTERN_3 = TunableWallPattern(description='additional wall pattern')
        WALL_PATTERN_4 = TunableWallPattern(description='additional wall pattern')
        WALL_PATTERN_5 = TunableWallPattern(description='additional wall pattern')
        BUILD_LADDER_1 = TunableBuildLadder(description='build ladder')

    class LotDescriptions:
        GAMEPLAY_SOAK_EXCLUSIONS = TunableSet(TunableLotDescription(pack_safe=True), description='A list of lots to exclude from travel in gameplaysoak test')

    class ClubSeeds:
        CHESS_CLUB_SEED = TunableReference(manager=services.get_instance_manager(sims4.resources.Types.CLUB_SEED), description='Chess Club')

    class Recipes:
        SMALL_CLAM_CHOWDER = TunablePackSafeReference(manager=services.get_instance_manager(sims4.resources.Types.RECIPE), description='Small clam chowder recipe')

    class Situations:
        HIGHSCHOOL_NPCS_SITUATION = TunablePackSafeReference(manager=services.get_instance_manager(sims4.resources.Types.SITUATION), description='Highschool NPCs situation')

    class SituationJobs:
        EXCURSION_MOUNTAIN_LEADER = TunablePackSafeReference(manager=services.get_instance_manager(sims4.resources.Types.SITUATION_JOB), description='Excursion Mountain Leader Job')
        EXCURSION_MOUNTAIN_CLIMBER = TunablePackSafeReference(manager=services.get_instance_manager(sims4.resources.Types.SITUATION_JOB), description='Excursion Mountain Climber Job')
        HIGHSCHOOL_NPC_PRINCIPAL = TunablePackSafeReference(manager=services.get_instance_manager(sims4.resources.Types.SITUATION_JOB), description='Highschool Prinipal Job')

    class Buffs:
        CHEATINGBUFF_OKAY = TunableReference(manager=services.get_instance_manager(sims4.resources.Types.BUFF), description='An Okay buff')
        BUFF_MEMORY_INSPIRED = TunableReference(manager=services.get_instance_manager(sims4.resources.Types.BUFF), description='Buff_Memory_inspired')
        BUFF_PREGNANCY_TRIMESTER1 = TunableReference(manager=services.get_instance_manager(sims4.resources.Types.BUFF), description='buff_Pregnancy_Trimester1')
        BUFF_PREGNANCY_TRIMESTER2 = TunableReference(manager=services.get_instance_manager(sims4.resources.Types.BUFF), description='buff_Pregnancy_Trimester2')
        BUFF_PREGNANCY_TRIMESTER3 = TunableReference(manager=services.get_instance_manager(sims4.resources.Types.BUFF), description='buff_Pregnancy_Trimester3')
        BUFF_ELECTROCUTION_WARNING = TunableReference(manager=services.get_instance_manager(sims4.resources.Types.BUFF), description='buff_Death_Electrocution_Warning')
        BUFF_READY_TO_ORDER = TunablePackSafeReference(manager=services.get_instance_manager(sims4.resources.Types.BUFF), description='buff_Restaurants_Diner_Player_PreplaceOrder')
        BUFF_OUTDOOR_WEATHER = TunablePackSafeReference(manager=services.get_instance_manager(sims4.resources.Types.BUFF), description='buff_Weather_Outside_Test')
        BUFF_INDOOR_WEATHER = TunablePackSafeReference(manager=services.get_instance_manager(sims4.resources.Types.BUFF), description='buff_Weather_Indoor_test')
        BUFF_TO_PREVENT_FEARS = TunablePackSafeReference(manager=services.get_instance_manager(sims4.resources.Types.BUFF), description='PreventFearTraitAdditions')
        BUFF_WEREWOLF_IN_BEAST_FORM = TunablePackSafeReference(manager=services.get_instance_manager(sims4.resources.Types.BUFF), description='buff_Werewolf_InBeastForm')
        BUFF_GOT_CLASS_LIST = TunablePackSafeReference(manager=services.get_instance_manager(sims4.resources.Types.BUFF), description='buff_HighSchool_Active_GotClassList')

    class Misc:
        AUTOMATION_VERSION = Tunable(int, default=1, description='\n            This value is read by the automated test script and used to determine which test behavior should be used.\n            In general, this value should be updated whenever game behavior that the automated test relies on is changed.\n            For usage info, please see http://maxisweb/sims4/index.php?title=Automation_Dependency_Versioning_System\n            ')
        NUM_TRAVEL_FAILURES = Tunable(int, default=3, description='\n            This value is used to tune the number of acceptable failures for automated tests that care about the number\n            of times travel can fail.\n        ')

    class CasParts:
        TEST_CAS_IN_GAME_EXCLUSIONS = TunableList(description='\n            CAS Parts that we want to exclude when comparing the CAS data with the in-game CAS data, during the\n            CAS In-Game PerPersistence - Verify Sim Data (TestCasInGame)\n            ', tunable=TunableCasPart(pack_safe=True), unique_entries=True)

IGNORED_ATTRIBUTES = ['MODULE_TUNABLES']
prefix_map = {Constants.CasParts: 'CASPART', Constants.SituationJobs: 'SITUATIONJOB', Constants.Situations: 'SITUATION', Constants.Buffs: 'BUFF', Constants.Recipes: 'RECIPE', Constants.ClubSeeds: 'CLUBSEED', Constants.LotDescriptions: 'LOTDESC', Constants.ResourceIds: 'RESOURCE', Constants.Misc: 'MISC', Constants.ObjectDefinitions: 'OBJ', Constants.Interactions: 'CLASSN', Constants.LocalizationStrings: 'LOCSTR'}

@sims4.commands.Command('qa.automation.get_constants', command_type=sims4.commands.CommandType.Automation)
def get_constants(_connection=None):
    for (species, sim_definition) in SimInfo.SIM_DEFINITIONS.items():
        species_name = str(species).split('.')[-1].upper()
        setattr(Constants.ObjectDefinitions, 'SIM_{}'.format(species_name), sim_definition)
    sims4.commands.automation_output('[ddConstants]AutomationConstants; Data:Begin', _connection)
    for group in prefix_map:
        for attribute in dir(group):
            if not attribute in IGNORED_ATTRIBUTES:
                if attribute.startswith('__'):
                    pass
                else:
                    original_value = getattr(group, attribute)
                    list_values = (original_value,) if not isinstance(original_value, (tuple, frozenset)) else original_value
                    if not list_values:
                        pass
                    else:
                        string_value = 'Key:{}, NumItems:{}'.format(attribute, len(list_values))
                        for (idx, raw_value) in enumerate(list_values):
                            if isinstance(raw_value, (int, str, float, bool)) or raw_value is None:
                                string_value += ', Value{}:{}'.format(idx, raw_value)
                            elif isinstance(raw_value, LocalizedString):
                                string_value += ', Value{}:{}'.format(idx, raw_value.hash)
                            elif isinstance(raw_value, Definition):
                                string_value += ', Value{}:{}'.format(idx, raw_value.definition.id)
                            elif isinstance(raw_value, (TunedInstanceMetaclass, TuningBlueprintBase)):
                                string_value += ', ClassName{}:{}'.format(idx, raw_value.__name__)
                                if hasattr(raw_value.display_name, '_string_id'):
                                    string_value += ', DisplayName{}:{}'.format(idx, raw_value.display_name._string_id)
                                additional_display_names = []
                                display_name_overrides = getattr(raw_value, 'display_name_overrides', None)
                                if hasattr(raw_value, 'display_name') and raw_value.display_name is not None and display_name_overrides is not None:
                                    additional_display_names.extend(display_name_overrides.get_display_names_gen())
                                display_name_in_queue = getattr(raw_value, 'display_name_in_queue', None)
                                if display_name_in_queue is not None:
                                    additional_display_names.append(display_name_in_queue)
                                visual_type_override_data = getattr(raw_value, 'visual_type_override_data', None)
                                if visual_type_override_data is not None and visual_type_override_data.tooltip_text is not None:
                                    additional_display_names.append(visual_type_override_data.tooltip_text)
                                single_choice_picker_display_override = getattr(raw_value, 'single_choice_display_name', None)
                                if single_choice_picker_display_override is not None:
                                    additional_display_names.append(single_choice_picker_display_override)
                                string_value += ', NumOverrides{}:{}'.format(idx, len(additional_display_names))
                                for (override_idx, override) in enumerate(additional_display_names):
                                    string_value += ', OverrideName{}_{}:{}'.format(idx, override_idx, override._string_id)
                                string_value += ', Value{}:{}'.format(idx, raw_value.guid64)
                            else:
                                string_value += ', Value{}:UNKNOWN_DATA_TYPE_{}'.format(idx, type(raw_value).__name__)
                        sims4.commands.automation_output('[ddConstants]AutomationConstants; Data:{}, {}'.format(prefix_map[group], string_value), _connection)
    sims4.commands.automation_output('[ddConstants]AutomationConstants; Data:End', _connection)

