__all__ = ['TestResult', 'TestCase', 'TestSuite', 'TextTestRunner', 'TestLoader', 'FunctionTestCase', 'main', 'defaultTestLoader', 'SkipTest', 'skip', 'skipIf', 'skipUnless', 'expectedFailure', 'TextTestResult', 'installHandler', 'registerResult', 'removeResult', 'removeHandler']
__all__.extend(['getTestCaseNames', 'makeSuite', 'findTestCases'])
__unittest = True
from result import TestResult
from case import TestCase, FunctionTestCase, SkipTest, skip, skipIf, skipUnless, expectedFailure
from suite import BaseTestSuite, TestSuite
from loader import TestLoader, defaultTestLoader, makeSuite, getTestCaseNames, findTestCases
from main import TestProgram, main
from runner import TextTestRunner, TextTestResult
from signals import installHandler, registerResult, removeResult, removeHandler
_TextTestResult = TextTestResult

def load_tests(loader, tests, pattern):
    import os.path
    this_dir = os.path.dirname(__file__)
    return loader.discover(start_dir=this_dir, pattern=pattern)

