__all__ = ['html5', 'name2codepoint', 'codepoint2name', 'entitydefs']
name2codepoint = {'AElig': 198, 'Aacute': 193, 'Acirc': 194, 'Agrave': 192, 'Alpha': 913, 'Aring': 197, 'Atilde': 195, 'Auml': 196, 'Beta': 914, 'Ccedil': 199, 'Chi': 935, 'Dagger': 8225, 'Delta': 916, 'ETH': 208, 'Eacute': 201, 'Ecirc': 202, 'Egrave': 200, 'Epsilon': 917, 'Eta': 919, 'Euml': 203, 'Gamma': 915, 'Iacute': 205, 'Icirc': 206, 'Igrave': 204, 'Iota': 921, 'Iuml': 207, 'Kappa': 922, 'Lambda': 923, 'Mu': 924, 'Ntilde': 209, 'Nu': 925, 'OElig': 338, 'Oacute': 211, 'Ocirc': 212, 'Ograve': 210, 'Omega': 937, 'Omicron': 927, 'Oslash': 216, 'Otilde': 213, 'Ouml': 214, 'Phi': 934, 'Pi': 928, 'Prime': 8243, 'Psi': 936, 'Rho': 929, 'Scaron': 352, 'Sigma': 931, 'THORN': 222, 'Tau': 932, 'Theta': 920, 'Uacute': 218, 'Ucirc': 219, 'Ugrave': 217, 'Upsilon': 933, 'Uuml': 220, 'Xi': 926, 'Yacute': 221, 'Yuml': 376, 'Zeta': 918, 'aacute': 225, 'acirc': 226, 'acute': 180, 'aelig': 230, 'agrave': 224, 'alefsym': 8501, 'alpha': 945, 'amp': 38, 'and': 8743, 'ang': 8736, 'aring': 229, 'asymp': 8776, 'atilde': 227, 'auml': 228, 'bdquo': 8222, 'beta': 946, 'brvbar': 166, 'bull': 8226, 'cap': 8745, 'ccedil': 231, 'cedil': 184, 'cent': 162, 'chi': 967, 'circ': 710, 'clubs': 9827, 'cong': 8773, 'copy': 169, 'crarr': 8629, 'cup': 8746, 'curren': 164, 'dArr': 8659, 'dagger': 8224, 'darr': 8595, 'deg': 176, 'delta': 948, 'diams': 9830, 'divide': 247, 'eacute': 233, 'ecirc': 234, 'egrave': 232, 'empty': 8709, 'emsp': 8195, 'ensp': 8194, 'epsilon': 949, 'equiv': 8801, 'eta': 951, 'eth': 240, 'euml': 235, 'euro': 8364, 'exist': 8707, 'fnof': 402, 'forall': 8704, 'frac12': 189, 'frac14': 188, 'frac34': 190, 'frasl': 8260, 'gamma': 947, 'ge': 8805, 'gt': 62, 'hArr': 8660, 'harr': 8596, 'hearts': 9829, 'hellip': 8230, 'iacute': 237, 'icirc': 238, 'iexcl': 161, 'igrave': 236, 'image': 8465, 'infin': 8734, 'int': 8747, 'iota': 953, 'iquest': 191, 'isin': 8712, 'iuml': 239, 'kappa': 954, 'lArr': 8656, 'lambda': 955, 'lang': 9001, 'laquo': 171, 'larr': 8592, 'lceil': 8968, 'ldquo': 8220, 'le': 8804, 'lfloor': 8970, 'lowast': 8727, 'loz': 9674, 'lrm': 8206, 'lsaquo': 8249, 'lsquo': 8216, 'lt': 60, 'macr': 175, 'mdash': 8212, 'micro': 181, 'middot': 183, 'minus': 8722, 'mu': 956, 'nabla': 8711, 'nbsp': 160, 'ndash': 8211, 'ne': 8800, 'ni': 8715, 'not': 172, 'notin': 8713, 'nsub': 8836, 'ntilde': 241, 'nu': 957, 'oacute': 243, 'ocirc': 244, 'oelig': 339, 'ograve': 242, 'oline': 8254, 'omega': 969, 'omicron': 959, 'oplus': 8853, 'or': 8744, 'ordf': 170, 'ordm': 186, 'oslash': 248, 'otilde': 245, 'otimes': 8855, 'ouml': 246, 'para': 182, 'part': 8706, 'permil': 8240, 'perp': 8869, 'phi': 966, 'pi': 960, 'piv': 982, 'plusmn': 177, 'pound': 163, 'prime': 8242, 'prod': 8719, 'prop': 8733, 'psi': 968, 'quot': 34, 'rArr': 8658, 'radic': 8730, 'rang': 9002, 'raquo': 187, 'rarr': 8594, 'rceil': 8969, 'rdquo': 8221, 'real': 8476, 'reg': 174, 'rfloor': 8971, 'rho': 961, 'rlm': 8207, 'rsaquo': 8250, 'rsquo': 8217, 'sbquo': 8218, 'scaron': 353, 'sdot': 8901, 'sect': 167, 'shy': 173, 'sigma': 963, 'sigmaf': 962, 'sim': 8764, 'spades': 9824, 'sub': 8834, 'sube': 8838, 'sum': 8721, 'sup': 8835, 'sup1': 185, 'sup2': 178, 'sup3': 179, 'supe': 8839, 'szlig': 223, 'tau': 964, 'there4': 8756, 'theta': 952, 'thetasym': 977, 'thinsp': 8201, 'thorn': 254, 'tilde': 732, 'times': 215, 'trade': 8482, 'uArr': 8657, 'uacute': 250, 'uarr': 8593, 'ucirc': 251, 'ugrave': 249, 'uml': 168, 'upsih': 978, 'upsilon': 965, 'uuml': 252, 'weierp': 8472, 'xi': 958, 'yacute': 253, 'yen': 165, 'yuml': 255, 'zeta': 950, 'zwj': 8205, 'zwnj': 8204}
html5 = {'Aacute': 'Á', 'aacute': 'á', 'Aacute;': 'Á', 'aacute;': 'á', 'Abreve;': 'Ă', 'abreve;': 'ă', 'ac;': '∾', 'acd;': '∿', 'acE;': '∾̳', 'Acirc': 'Â', 'acirc': 'â', 'Acirc;': 'Â', 'acirc;': 'â', 'acute': '´', 'acute;': '´', 'Acy;': 'А', 'acy;': 'а', 'AElig': 'Æ', 'aelig': 'æ', 'AElig;': 'Æ', 'aelig;': 'æ', 'af;': '\u2061', 'Afr;': '𝔄', 'afr;': '𝔞', 'Agrave': 'À', 'agrave': 'à', 'Agrave;': 'À', 'agrave;': 'à', 'alefsym;': 'ℵ', 'aleph;': 'ℵ', 'Alpha;': 'Α', 'alpha;': 'α', 'Amacr;': 'Ā', 'amacr;': 'ā', 'amalg;': '⨿', 'AMP': '&', 'amp': '&', 'AMP;': '&', 'amp;': '&', 'And;': '⩓', 'and;': '∧', 'andand;': '⩕', 'andd;': '⩜', 'andslope;': '⩘', 'andv;': '⩚', 'ang;': '∠', 'ange;': '⦤', 'angle;': '∠', 'angmsd;': '∡', 'angmsdaa;': '⦨', 'angmsdab;': '⦩', 'angmsdac;': '⦪', 'angmsdad;': '⦫', 'angmsdae;': '⦬', 'angmsdaf;': '⦭', 'angmsdag;': '⦮', 'angmsdah;': '⦯', 'angrt;': '∟', 'angrtvb;': '⊾', 'angrtvbd;': '⦝', 'angsph;': '∢', 'angst;': 'Å', 'angzarr;': '⍼', 'Aogon;': 'Ą', 'aogon;': 'ą', 'Aopf;': '𝔸', 'aopf;': '𝕒', 'ap;': '≈', 'apacir;': '⩯', 'apE;': '⩰', 'ape;': '≊', 'apid;': '≋', 'apos;': "'", 'ApplyFunction;': '\u2061', 'approx;': '≈', 'approxeq;': '≊', 'Aring': 'Å', 'aring': 'å', 'Aring;': 'Å', 'aring;': 'å', 'Ascr;': '𝒜', 'ascr;': '𝒶', 'Assign;': '≔', 'ast;': '*', 'asymp;': '≈', 'asympeq;': '≍', 'Atilde': 'Ã', 'atilde': 'ã', 'Atilde;': 'Ã', 'atilde;': 'ã', 'Auml': 'Ä', 'auml': 'ä', 'Auml;': 'Ä', 'auml;': 'ä', 'awconint;': '∳', 'awint;': '⨑', 'backcong;': '≌', 'backepsilon;': '϶', 'backprime;': '‵', 'backsim;': '∽', 'backsimeq;': '⋍', 'Backslash;': '∖', 'Barv;': '⫧', 'barvee;': '⊽', 'Barwed;': '⌆', 'barwed;': '⌅', 'barwedge;': '⌅', 'bbrk;': '⎵', 'bbrktbrk;': '⎶', 'bcong;': '≌', 'Bcy;': 'Б', 'bcy;': 'б', 'bdquo;': '„', 'becaus;': '∵', 'Because;': '∵', 'because;': '∵', 'bemptyv;': '⦰', 'bepsi;': '϶', 'bernou;': 'ℬ', 'Bernoullis;': 'ℬ', 'Beta;': 'Β', 'beta;': 'β', 'beth;': 'ℶ', 'between;': '≬', 'Bfr;': '𝔅', 'bfr;': '𝔟', 'bigcap;': '⋂', 'bigcirc;': '◯', 'bigcup;': '⋃', 'bigodot;': '⨀', 'bigoplus;': '⨁', 'bigotimes;': '⨂', 'bigsqcup;': '⨆', 'bigstar;': '★', 'bigtriangledown;': '▽', 'bigtriangleup;': '△', 'biguplus;': '⨄', 'bigvee;': '⋁', 'bigwedge;': '⋀', 'bkarow;': '⤍', 'blacklozenge;': '⧫', 'blacksquare;': '▪', 'blacktriangle;': '▴', 'blacktriangledown;': '▾', 'blacktriangleleft;': '◂', 'blacktriangleright;': '▸', 'blank;': '␣', 'blk12;': '▒', 'blk14;': '░', 'blk34;': '▓', 'block;': '█', 'bne;': '=⃥', 'bnequiv;': '≡⃥', 'bNot;': '⫭', 'bnot;': '⌐', 'Bopf;': '𝔹', 'bopf;': '𝕓', 'bot;': '⊥', 'bottom;': '⊥', 'bowtie;': '⋈', 'boxbox;': '⧉', 'boxDL;': '╗', 'boxDl;': '╖', 'boxdL;': '╕', 'boxdl;': '┐', 'boxDR;': '╔', 'boxDr;': '╓', 'boxdR;': '╒', 'boxdr;': '┌', 'boxH;': '═', 'boxh;': '─', 'boxHD;': '╦', 'boxHd;': '╤', 'boxhD;': '╥', 'boxhd;': '┬', 'boxHU;': '╩', 'boxHu;': '╧', 'boxhU;': '╨', 'boxhu;': '┴', 'boxminus;': '⊟', 'boxplus;': '⊞', 'boxtimes;': '⊠', 'boxUL;': '╝', 'boxUl;': '╜', 'boxuL;': '╛', 'boxul;': '┘', 'boxUR;': '╚', 'boxUr;': '╙', 'boxuR;': '╘', 'boxur;': '└', 'boxV;': '║', 'boxv;': '│', 'boxVH;': '╬', 'boxVh;': '╫', 'boxvH;': '╪', 'boxvh;': '┼', 'boxVL;': '╣', 'boxVl;': '╢', 'boxvL;': '╡', 'boxvl;': '┤', 'boxVR;': '╠', 'boxVr;': '╟', 'boxvR;': '╞', 'boxvr;': '├', 'bprime;': '‵', 'Breve;': '˘', 'breve;': '˘', 'brvbar': '¦', 'brvbar;': '¦', 'Bscr;': 'ℬ', 'bscr;': '𝒷', 'bsemi;': '⁏', 'bsim;': '∽', 'bsime;': '⋍', 'bsol;': '\\', 'bsolb;': '⧅', 'bsolhsub;': '⟈', 'bull;': '•', 'bullet;': '•', 'bump;': '≎', 'bumpE;': '⪮', 'bumpe;': '≏', 'Bumpeq;': '≎', 'bumpeq;': '≏', 'Cacute;': 'Ć', 'cacute;': 'ć', 'Cap;': '⋒', 'cap;': '∩', 'capand;': '⩄', 'capbrcup;': '⩉', 'capcap;': '⩋', 'capcup;': '⩇', 'capdot;': '⩀', 'CapitalDifferentialD;': 'ⅅ', 'caps;': '∩︀', 'caret;': '⁁', 'caron;': 'ˇ', 'Cayleys;': 'ℭ', 'ccaps;': '⩍', 'Ccaron;': 'Č', 'ccaron;': 'č', 'Ccedil': 'Ç', 'ccedil': 'ç', 'Ccedil;': 'Ç', 'ccedil;': 'ç', 'Ccirc;': 'Ĉ', 'ccirc;': 'ĉ', 'Cconint;': '∰', 'ccups;': '⩌', 'ccupssm;': '⩐', 'Cdot;': 'Ċ', 'cdot;': 'ċ', 'cedil': '¸', 'cedil;': '¸', 'Cedilla;': '¸', 'cemptyv;': '⦲', 'cent': '¢', 'cent;': '¢', 'CenterDot;': '·', 'centerdot;': '·', 'Cfr;': 'ℭ', 'cfr;': '𝔠', 'CHcy;': 'Ч', 'chcy;': 'ч', 'check;': '✓', 'checkmark;': '✓', 'Chi;': 'Χ', 'chi;': 'χ', 'cir;': '○', 'circ;': 'ˆ', 'circeq;': '≗', 'circlearrowleft;': '↺', 'circlearrowright;': '↻', 'circledast;': '⊛', 'circledcirc;': '⊚', 'circleddash;': '⊝', 'CircleDot;': '⊙', 'circledR;': '®', 'circledS;': 'Ⓢ', 'CircleMinus;': '⊖', 'CirclePlus;': '⊕', 'CircleTimes;': '⊗', 'cirE;': '⧃', 'cire;': '≗', 'cirfnint;': '⨐', 'cirmid;': '⫯', 'cirscir;': '⧂', 'ClockwiseContourIntegral;': '∲', 'CloseCurlyDoubleQuote;': '”', 'CloseCurlyQuote;': '’', 'clubs;': '♣', 'clubsuit;': '♣', 'Colon;': '∷', 'colon;': ':', 'Colone;': '⩴', 'colone;': '≔', 'coloneq;': '≔', 'comma;': ',', 'commat;': '@', 'comp;': '∁', 'compfn;': '∘', 'complement;': '∁', 'complexes;': 'ℂ', 'cong;': '≅', 'congdot;': '⩭', 'Congruent;': '≡', 'Conint;': '∯', 'conint;': '∮', 'ContourIntegral;': '∮', 'Copf;': 'ℂ', 'copf;': '𝕔', 'coprod;': '∐', 'Coproduct;': '∐', 'COPY': '©', 'copy': '©', 'COPY;': '©', 'copy;': '©', 'copysr;': '℗', 'CounterClockwiseContourIntegral;': '∳', 'crarr;': '↵', 'Cross;': '⨯', 'cross;': '✗', 'Cscr;': '𝒞', 'cscr;': '𝒸', 'csub;': '⫏', 'csube;': '⫑', 'csup;': '⫐', 'csupe;': '⫒', 'ctdot;': '⋯', 'cudarrl;': '⤸', 'cudarrr;': '⤵', 'cuepr;': '⋞', 'cuesc;': '⋟', 'cularr;': '↶', 'cularrp;': '⤽', 'Cup;': '⋓', 'cup;': '∪', 'cupbrcap;': '⩈', 'CupCap;': '≍', 'cupcap;': '⩆', 'cupcup;': '⩊', 'cupdot;': '⊍', 'cupor;': '⩅', 'cups;': '∪︀', 'curarr;': '↷', 'curarrm;': '⤼', 'curlyeqprec;': '⋞', 'curlyeqsucc;': '⋟', 'curlyvee;': '⋎', 'curlywedge;': '⋏', 'curren': '¤', 'curren;': '¤', 'curvearrowleft;': '↶', 'curvearrowright;': '↷', 'cuvee;': '⋎', 'cuwed;': '⋏', 'cwconint;': '∲', 'cwint;': '∱', 'cylcty;': '⌭', 'Dagger;': '‡', 'dagger;': '†', 'daleth;': 'ℸ', 'Darr;': '↡', 'dArr;': '⇓', 'darr;': '↓', 'dash;': '‐', 'Dashv;': '⫤', 'dashv;': '⊣', 'dbkarow;': '⤏', 'dblac;': '˝', 'Dcaron;': 'Ď', 'dcaron;': 'ď', 'Dcy;': 'Д', 'dcy;': 'д', 'DD;': 'ⅅ', 'dd;': 'ⅆ', 'ddagger;': '‡', 'ddarr;': '⇊', 'DDotrahd;': '⤑', 'ddotseq;': '⩷', 'deg': '°', 'deg;': '°', 'Del;': '∇', 'Delta;': 'Δ', 'delta;': 'δ', 'demptyv;': '⦱', 'dfisht;': '⥿', 'Dfr;': '𝔇', 'dfr;': '𝔡', 'dHar;': '⥥', 'dharl;': '⇃', 'dharr;': '⇂', 'DiacriticalAcute;': '´', 'DiacriticalDot;': '˙', 'DiacriticalDoubleAcute;': '˝', 'DiacriticalGrave;': '`', 'DiacriticalTilde;': '˜', 'diam;': '⋄', 'Diamond;': '⋄', 'diamond;': '⋄', 'diamondsuit;': '♦', 'diams;': '♦', 'die;': '¨', 'DifferentialD;': 'ⅆ', 'digamma;': 'ϝ', 'disin;': '⋲', 'div;': '÷', 'divide': '÷', 'divide;': '÷', 'divideontimes;': '⋇', 'divonx;': '⋇', 'DJcy;': 'Ђ', 'djcy;': 'ђ', 'dlcorn;': '⌞', 'dlcrop;': '⌍', 'dollar;': '$', 'Dopf;': '𝔻', 'dopf;': '𝕕', 'Dot;': '¨', 'dot;': '˙', 'DotDot;': '⃜', 'doteq;': '≐', 'doteqdot;': '≑', 'DotEqual;': '≐', 'dotminus;': '∸', 'dotplus;': '∔', 'dotsquare;': '⊡', 'doublebarwedge;': '⌆', 'DoubleContourIntegral;': '∯', 'DoubleDot;': '¨', 'DoubleDownArrow;': '⇓', 'DoubleLeftArrow;': '⇐', 'DoubleLeftRightArrow;': '⇔', 'DoubleLeftTee;': '⫤', 'DoubleLongLeftArrow;': '⟸', 'DoubleLongLeftRightArrow;': '⟺', 'DoubleLongRightArrow;': '⟹', 'DoubleRightArrow;': '⇒', 'DoubleRightTee;': '⊨', 'DoubleUpArrow;': '⇑', 'DoubleUpDownArrow;': '⇕', 'DoubleVerticalBar;': '∥', 'DownArrow;': '↓', 'Downarrow;': '⇓', 'downarrow;': '↓', 'DownArrowBar;': '⤓', 'DownArrowUpArrow;': '⇵', 'DownBreve;': '̑', 'downdownarrows;': '⇊', 'downharpoonleft;': '⇃', 'downharpoonright;': '⇂', 'DownLeftRightVector;': '⥐', 'DownLeftTeeVector;': '⥞', 'DownLeftVector;': '↽', 'DownLeftVectorBar;': '⥖', 'DownRightTeeVector;': '⥟', 'DownRightVector;': '⇁', 'DownRightVectorBar;': '⥗', 'DownTee;': '⊤', 'DownTeeArrow;': '↧', 'drbkarow;': '⤐', 'drcorn;': '⌟', 'drcrop;': '⌌', 'Dscr;': '𝒟', 'dscr;': '𝒹', 'DScy;': 'Ѕ', 'dscy;': 'ѕ', 'dsol;': '⧶', 'Dstrok;': 'Đ', 'dstrok;': 'đ', 'dtdot;': '⋱', 'dtri;': '▿', 'dtrif;': '▾', 'duarr;': '⇵', 'duhar;': '⥯', 'dwangle;': '⦦', 'DZcy;': 'Џ', 'dzcy;': 'џ', 'dzigrarr;': '⟿', 'Eacute': 'É', 'eacute': 'é', 'Eacute;': 'É', 'eacute;': 'é', 'easter;': '⩮', 'Ecaron;': 'Ě', 'ecaron;': 'ě', 'ecir;': '≖', 'Ecirc': 'Ê', 'ecirc': 'ê', 'Ecirc;': 'Ê', 'ecirc;': 'ê', 'ecolon;': '≕', 'Ecy;': 'Э', 'ecy;': 'э', 'eDDot;': '⩷', 'Edot;': 'Ė', 'eDot;': '≑', 'edot;': 'ė', 'ee;': 'ⅇ', 'efDot;': '≒', 'Efr;': '𝔈', 'efr;': '𝔢', 'eg;': '⪚', 'Egrave': 'È', 'egrave': 'è', 'Egrave;': 'È', 'egrave;': 'è', 'egs;': '⪖', 'egsdot;': '⪘', 'el;': '⪙', 'Element;': '∈', 'elinters;': '⏧', 'ell;': 'ℓ', 'els;': '⪕', 'elsdot;': '⪗', 'Emacr;': 'Ē', 'emacr;': 'ē', 'empty;': '∅', 'emptyset;': '∅', 'EmptySmallSquare;': '◻', 'emptyv;': '∅', 'EmptyVerySmallSquare;': '▫', 'emsp13;': '\u2004', 'emsp14;': '\u2005', 'emsp;': '\u2003', 'ENG;': 'Ŋ', 'eng;': 'ŋ', 'ensp;': '\u2002', 'Eogon;': 'Ę', 'eogon;': 'ę', 'Eopf;': '𝔼', 'eopf;': '𝕖', 'epar;': '⋕', 'eparsl;': '⧣', 'eplus;': '⩱', 'epsi;': 'ε', 'Epsilon;': 'Ε', 'epsilon;': 'ε', 'epsiv;': 'ϵ', 'eqcirc;': '≖', 'eqcolon;': '≕', 'eqsim;': '≂', 'eqslantgtr;': '⪖', 'eqslantless;': '⪕', 'Equal;': '⩵', 'equals;': '=', 'EqualTilde;': '≂', 'equest;': '≟', 'Equilibrium;': '⇌', 'equiv;': '≡', 'equivDD;': '⩸', 'eqvparsl;': '⧥', 'erarr;': '⥱', 'erDot;': '≓', 'Escr;': 'ℰ', 'escr;': 'ℯ', 'esdot;': '≐', 'Esim;': '⩳', 'esim;': '≂', 'Eta;': 'Η', 'eta;': 'η', 'ETH': 'Ð', 'eth': 'ð', 'ETH;': 'Ð', 'eth;': 'ð', 'Euml': 'Ë', 'euml': 'ë', 'Euml;': 'Ë', 'euml;': 'ë', 'euro;': '€', 'excl;': '!', 'exist;': '∃', 'Exists;': '∃', 'expectation;': 'ℰ', 'ExponentialE;': 'ⅇ', 'exponentiale;': 'ⅇ', 'fallingdotseq;': '≒', 'Fcy;': 'Ф', 'fcy;': 'ф', 'female;': '♀', 'ffilig;': 'ﬃ', 'fflig;': 'ﬀ', 'ffllig;': 'ﬄ', 'Ffr;': '𝔉', 'ffr;': '𝔣', 'filig;': 'ﬁ', 'FilledSmallSquare;': '◼', 'FilledVerySmallSquare;': '▪', 'fjlig;': 'fj', 'flat;': '♭', 'fllig;': 'ﬂ', 'fltns;': '▱', 'fnof;': 'ƒ', 'Fopf;': '𝔽', 'fopf;': '𝕗', 'ForAll;': '∀', 'forall;': '∀', 'fork;': '⋔', 'forkv;': '⫙', 'Fouriertrf;': 'ℱ', 'fpartint;': '⨍', 'frac12': '½', 'frac12;': '½', 'frac13;': '⅓', 'frac14': '¼', 'frac14;': '¼', 'frac15;': '⅕', 'frac16;': '⅙', 'frac18;': '⅛', 'frac23;': '⅔', 'frac25;': '⅖', 'frac34': '¾', 'frac34;': '¾', 'frac35;': '⅗', 'frac38;': '⅜', 'frac45;': '⅘', 'frac56;': '⅚', 'frac58;': '⅝', 'frac78;': '⅞', 'frasl;': '⁄', 'frown;': '⌢', 'Fscr;': 'ℱ', 'fscr;': '𝒻', 'gacute;': 'ǵ', 'Gamma;': 'Γ', 'gamma;': 'γ', 'Gammad;': 'Ϝ', 'gammad;': 'ϝ', 'gap;': '⪆', 'Gbreve;': 'Ğ', 'gbreve;': 'ğ', 'Gcedil;': 'Ģ', 'Gcirc;': 'Ĝ', 'gcirc;': 'ĝ', 'Gcy;': 'Г', 'gcy;': 'г', 'Gdot;': 'Ġ', 'gdot;': 'ġ', 'gE;': '≧', 'ge;': '≥', 'gEl;': '⪌', 'gel;': '⋛', 'geq;': '≥', 'geqq;': '≧', 'geqslant;': '⩾', 'ges;': '⩾', 'gescc;': '⪩', 'gesdot;': '⪀', 'gesdoto;': '⪂', 'gesdotol;': '⪄', 'gesl;': '⋛︀', 'gesles;': '⪔', 'Gfr;': '𝔊', 'gfr;': '𝔤', 'Gg;': '⋙', 'gg;': '≫', 'ggg;': '⋙', 'gimel;': 'ℷ', 'GJcy;': 'Ѓ', 'gjcy;': 'ѓ', 'gl;': '≷', 'gla;': '⪥', 'glE;': '⪒', 'glj;': '⪤', 'gnap;': '⪊', 'gnapprox;': '⪊', 'gnE;': '≩', 'gne;': '⪈', 'gneq;': '⪈', 'gneqq;': '≩', 'gnsim;': '⋧', 'Gopf;': '𝔾', 'gopf;': '𝕘', 'grave;': '`', 'GreaterEqual;': '≥', 'GreaterEqualLess;': '⋛', 'GreaterFullEqual;': '≧', 'GreaterGreater;': '⪢', 'GreaterLess;': '≷', 'GreaterSlantEqual;': '⩾', 'GreaterTilde;': '≳', 'Gscr;': '𝒢', 'gscr;': 'ℊ', 'gsim;': '≳', 'gsime;': '⪎', 'gsiml;': '⪐', 'GT': '>', 'gt': '>', 'GT;': '>', 'Gt;': '≫', 'gt;': '>', 'gtcc;': '⪧', 'gtcir;': '⩺', 'gtdot;': '⋗', 'gtlPar;': '⦕', 'gtquest;': '⩼', 'gtrapprox;': '⪆', 'gtrarr;': '⥸', 'gtrdot;': '⋗', 'gtreqless;': '⋛', 'gtreqqless;': '⪌', 'gtrless;': '≷', 'gtrsim;': '≳', 'gvertneqq;': '≩︀', 'gvnE;': '≩︀', 'Hacek;': 'ˇ', 'hairsp;': '\u200a', 'half;': '½', 'hamilt;': 'ℋ', 'HARDcy;': 'Ъ', 'hardcy;': 'ъ', 'hArr;': '⇔', 'harr;': '↔', 'harrcir;': '⥈', 'harrw;': '↭', 'Hat;': '^', 'hbar;': 'ℏ', 'Hcirc;': 'Ĥ', 'hcirc;': 'ĥ', 'hearts;': '♥', 'heartsuit;': '♥', 'hellip;': '…', 'hercon;': '⊹', 'Hfr;': 'ℌ', 'hfr;': '𝔥', 'HilbertSpace;': 'ℋ', 'hksearow;': '⤥', 'hkswarow;': '⤦', 'hoarr;': '⇿', 'homtht;': '∻', 'hookleftarrow;': '↩', 'hookrightarrow;': '↪', 'Hopf;': 'ℍ', 'hopf;': '𝕙', 'horbar;': '―', 'HorizontalLine;': '─', 'Hscr;': 'ℋ', 'hscr;': '𝒽', 'hslash;': 'ℏ', 'Hstrok;': 'Ħ', 'hstrok;': 'ħ', 'HumpDownHump;': '≎', 'HumpEqual;': '≏', 'hybull;': '⁃', 'hyphen;': '‐', 'Iacute': 'Í', 'iacute': 'í', 'Iacute;': 'Í', 'iacute;': 'í', 'ic;': '\u2063', 'Icirc': 'Î', 'icirc': 'î', 'Icirc;': 'Î', 'icirc;': 'î', 'Icy;': 'И', 'icy;': 'и', 'Idot;': 'İ', 'IEcy;': 'Е', 'iecy;': 'е', 'iexcl': '¡', 'iexcl;': '¡', 'iff;': '⇔', 'Ifr;': 'ℑ', 'ifr;': '𝔦', 'Igrave': 'Ì', 'igrave': 'ì', 'Igrave;': 'Ì', 'igrave;': 'ì', 'ii;': 'ⅈ', 'iiiint;': '⨌', 'iiint;': '∭', 'iinfin;': '⧜', 'iiota;': '℩', 'IJlig;': 'Ĳ', 'ijlig;': 'ĳ', 'Im;': 'ℑ', 'Imacr;': 'Ī', 'imacr;': 'ī', 'image;': 'ℑ', 'ImaginaryI;': 'ⅈ', 'imagline;': 'ℐ', 'imagpart;': 'ℑ', 'imath;': 'ı', 'imof;': '⊷', 'imped;': 'Ƶ', 'Implies;': '⇒', 'in;': '∈', 'incare;': '℅', 'infin;': '∞', 'infintie;': '⧝', 'inodot;': 'ı', 'Int;': '∬', 'int;': '∫', 'intcal;': '⊺', 'integers;': 'ℤ', 'Integral;': '∫', 'intercal;': '⊺', 'Intersection;': '⋂', 'intlarhk;': '⨗', 'intprod;': '⨼', 'InvisibleComma;': '\u2063', 'InvisibleTimes;': '\u2062', 'IOcy;': 'Ё', 'iocy;': 'ё', 'Iogon;': 'Į', 'iogon;': 'į', 'Iopf;': '𝕀', 'iopf;': '𝕚', 'Iota;': 'Ι', 'iota;': 'ι', 'iprod;': '⨼', 'iquest': '¿', 'iquest;': '¿', 'Iscr;': 'ℐ', 'iscr;': '𝒾', 'isin;': '∈', 'isindot;': '⋵', 'isinE;': '⋹', 'isins;': '⋴', 'isinsv;': '⋳', 'isinv;': '∈', 'it;': '\u2062', 'Itilde;': 'Ĩ', 'itilde;': 'ĩ', 'Iukcy;': 'І', 'iukcy;': 'і', 'Iuml': 'Ï', 'iuml': 'ï', 'Iuml;': 'Ï', 'iuml;': 'ï', 'Jcirc;': 'Ĵ', 'jcirc;': 'ĵ', 'Jcy;': 'Й', 'jcy;': 'й', 'Jfr;': '𝔍', 'jfr;': '𝔧', 'jmath;': 'ȷ', 'Jopf;': '𝕁', 'jopf;': '𝕛', 'Jscr;': '𝒥', 'jscr;': '𝒿', 'Jsercy;': 'Ј', 'jsercy;': 'ј', 'Jukcy;': 'Є', 'jukcy;': 'є', 'Kappa;': 'Κ', 'kappa;': 'κ', 'kappav;': 'ϰ', 'Kcedil;': 'Ķ', 'kcedil;': 'ķ', 'Kcy;': 'К', 'kcy;': 'к', 'Kfr;': '𝔎', 'kfr;': '𝔨', 'kgreen;': 'ĸ', 'KHcy;': 'Х', 'khcy;': 'х', 'KJcy;': 'Ќ', 'kjcy;': 'ќ', 'Kopf;': '𝕂', 'kopf;': '𝕜', 'Kscr;': '𝒦', 'kscr;': '𝓀', 'lAarr;': '⇚', 'Lacute;': 'Ĺ', 'lacute;': 'ĺ', 'laemptyv;': '⦴', 'lagran;': 'ℒ', 'Lambda;': 'Λ', 'lambda;': 'λ', 'Lang;': '⟪', 'lang;': '⟨', 'langd;': '⦑', 'langle;': '⟨', 'lap;': '⪅', 'Laplacetrf;': 'ℒ', 'laquo': '«', 'laquo;': '«', 'Larr;': '↞', 'lArr;': '⇐', 'larr;': '←', 'larrb;': '⇤', 'larrbfs;': '⤟', 'larrfs;': '⤝', 'larrhk;': '↩', 'larrlp;': '↫', 'larrpl;': '⤹', 'larrsim;': '⥳', 'larrtl;': '↢', 'lat;': '⪫', 'lAtail;': '⤛', 'latail;': '⤙', 'late;': '⪭', 'lates;': '⪭︀', 'lBarr;': '⤎', 'lbarr;': '⤌', 'lbbrk;': '❲', 'lbrace;': '{', 'lbrack;': '[', 'lbrke;': '⦋', 'lbrksld;': '⦏', 'lbrkslu;': '⦍', 'Lcaron;': 'Ľ', 'lcaron;': 'ľ', 'Lcedil;': 'Ļ', 'lcedil;': 'ļ', 'lceil;': '⌈', 'lcub;': '{', 'Lcy;': 'Л', 'lcy;': 'л', 'ldca;': '⤶', 'ldquo;': '“', 'ldquor;': '„', 'ldrdhar;': '⥧', 'ldrushar;': '⥋', 'ldsh;': '↲', 'lE;': '≦', 'le;': '≤', 'LeftAngleBracket;': '⟨', 'LeftArrow;': '←', 'Leftarrow;': '⇐', 'leftarrow;': '←', 'LeftArrowBar;': '⇤', 'LeftArrowRightArrow;': '⇆', 'leftarrowtail;': '↢', 'LeftCeiling;': '⌈', 'LeftDoubleBracket;': '⟦', 'LeftDownTeeVector;': '⥡', 'LeftDownVector;': '⇃', 'LeftDownVectorBar;': '⥙', 'LeftFloor;': '⌊', 'leftharpoondown;': '↽', 'leftharpoonup;': '↼', 'leftleftarrows;': '⇇', 'LeftRightArrow;': '↔', 'Leftrightarrow;': '⇔', 'leftrightarrow;': '↔', 'leftrightarrows;': '⇆', 'leftrightharpoons;': '⇋', 'leftrightsquigarrow;': '↭', 'LeftRightVector;': '⥎', 'LeftTee;': '⊣', 'LeftTeeArrow;': '↤', 'LeftTeeVector;': '⥚', 'leftthreetimes;': '⋋', 'LeftTriangle;': '⊲', 'LeftTriangleBar;': '⧏', 'LeftTriangleEqual;': '⊴', 'LeftUpDownVector;': '⥑', 'LeftUpTeeVector;': '⥠', 'LeftUpVector;': '↿', 'LeftUpVectorBar;': '⥘', 'LeftVector;': '↼', 'LeftVectorBar;': '⥒', 'lEg;': '⪋', 'leg;': '⋚', 'leq;': '≤', 'leqq;': '≦', 'leqslant;': '⩽', 'les;': '⩽', 'lescc;': '⪨', 'lesdot;': '⩿', 'lesdoto;': '⪁', 'lesdotor;': '⪃', 'lesg;': '⋚︀', 'lesges;': '⪓', 'lessapprox;': '⪅', 'lessdot;': '⋖', 'lesseqgtr;': '⋚', 'lesseqqgtr;': '⪋', 'LessEqualGreater;': '⋚', 'LessFullEqual;': '≦', 'LessGreater;': '≶', 'lessgtr;': '≶', 'LessLess;': '⪡', 'lesssim;': '≲', 'LessSlantEqual;': '⩽', 'LessTilde;': '≲', 'lfisht;': '⥼', 'lfloor;': '⌊', 'Lfr;': '𝔏', 'lfr;': '𝔩', 'lg;': '≶', 'lgE;': '⪑', 'lHar;': '⥢', 'lhard;': '↽', 'lharu;': '↼', 'lharul;': '⥪', 'lhblk;': '▄', 'LJcy;': 'Љ', 'ljcy;': 'љ', 'Ll;': '⋘', 'll;': '≪', 'llarr;': '⇇', 'llcorner;': '⌞', 'Lleftarrow;': '⇚', 'llhard;': '⥫', 'lltri;': '◺', 'Lmidot;': 'Ŀ', 'lmidot;': 'ŀ', 'lmoust;': '⎰', 'lmoustache;': '⎰', 'lnap;': '⪉', 'lnapprox;': '⪉', 'lnE;': '≨', 'lne;': '⪇', 'lneq;': '⪇', 'lneqq;': '≨', 'lnsim;': '⋦', 'loang;': '⟬', 'loarr;': '⇽', 'lobrk;': '⟦', 'LongLeftArrow;': '⟵', 'Longleftarrow;': '⟸', 'longleftarrow;': '⟵', 'LongLeftRightArrow;': '⟷', 'Longleftrightarrow;': '⟺', 'longleftrightarrow;': '⟷', 'longmapsto;': '⟼', 'LongRightArrow;': '⟶', 'Longrightarrow;': '⟹', 'longrightarrow;': '⟶', 'looparrowleft;': '↫', 'looparrowright;': '↬', 'lopar;': '⦅', 'Lopf;': '𝕃', 'lopf;': '𝕝', 'loplus;': '⨭', 'lotimes;': '⨴', 'lowast;': '∗', 'lowbar;': '_', 'LowerLeftArrow;': '↙', 'LowerRightArrow;': '↘', 'loz;': '◊', 'lozenge;': '◊', 'lozf;': '⧫', 'lpar;': '(', 'lparlt;': '⦓', 'lrarr;': '⇆', 'lrcorner;': '⌟', 'lrhar;': '⇋', 'lrhard;': '⥭', 'lrm;': '\u200e', 'lrtri;': '⊿', 'lsaquo;': '‹', 'Lscr;': 'ℒ', 'lscr;': '𝓁', 'Lsh;': '↰', 'lsh;': '↰', 'lsim;': '≲', 'lsime;': '⪍', 'lsimg;': '⪏', 'lsqb;': '[', 'lsquo;': '‘', 'lsquor;': '‚', 'Lstrok;': 'Ł', 'lstrok;': 'ł', 'LT': '<', 'lt': '<', 'LT;': '<', 'Lt;': '≪', 'lt;': '<', 'ltcc;': '⪦', 'ltcir;': '⩹', 'ltdot;': '⋖', 'lthree;': '⋋', 'ltimes;': '⋉', 'ltlarr;': '⥶', 'ltquest;': '⩻', 'ltri;': '◃', 'ltrie;': '⊴', 'ltrif;': '◂', 'ltrPar;': '⦖', 'lurdshar;': '⥊', 'luruhar;': '⥦', 'lvertneqq;': '≨︀', 'lvnE;': '≨︀', 'macr': '¯', 'macr;': '¯', 'male;': '♂', 'malt;': '✠', 'maltese;': '✠', 'Map;': '⤅', 'map;': '↦', 'mapsto;': '↦', 'mapstodown;': '↧', 'mapstoleft;': '↤', 'mapstoup;': '↥', 'marker;': '▮', 'mcomma;': '⨩', 'Mcy;': 'М', 'mcy;': 'м', 'mdash;': '—', 'mDDot;': '∺', 'measuredangle;': '∡', 'MediumSpace;': '\u205f', 'Mellintrf;': 'ℳ', 'Mfr;': '𝔐', 'mfr;': '𝔪', 'mho;': '℧', 'micro': 'µ', 'micro;': 'µ', 'mid;': '∣', 'midast;': '*', 'midcir;': '⫰', 'middot': '·', 'middot;': '·', 'minus;': '−', 'minusb;': '⊟', 'minusd;': '∸', 'minusdu;': '⨪', 'MinusPlus;': '∓', 'mlcp;': '⫛', 'mldr;': '…', 'mnplus;': '∓', 'models;': '⊧', 'Mopf;': '𝕄', 'mopf;': '𝕞', 'mp;': '∓', 'Mscr;': 'ℳ', 'mscr;': '𝓂', 'mstpos;': '∾', 'Mu;': 'Μ', 'mu;': 'μ', 'multimap;': '⊸', 'mumap;': '⊸', 'nabla;': '∇', 'Nacute;': 'Ń', 'nacute;': 'ń', 'nang;': '∠⃒', 'nap;': '≉', 'napE;': '⩰̸', 'napid;': '≋̸', 'napos;': 'ŉ', 'napprox;': '≉', 'natur;': '♮', 'natural;': '♮', 'naturals;': 'ℕ', 'nbsp': '\xa0', 'nbsp;': '\xa0', 'nbump;': '≎̸', 'nbumpe;': '≏̸', 'ncap;': '⩃', 'Ncaron;': 'Ň', 'ncaron;': 'ň', 'Ncedil;': 'Ņ', 'ncedil;': 'ņ', 'ncong;': '≇', 'ncongdot;': '⩭̸', 'ncup;': '⩂', 'Ncy;': 'Н', 'ncy;': 'н', 'ndash;': '–', 'ne;': '≠', 'nearhk;': '⤤', 'neArr;': '⇗', 'nearr;': '↗', 'nearrow;': '↗', 'nedot;': '≐̸', 'NegativeMediumSpace;': '\u200b', 'NegativeThickSpace;': '\u200b', 'NegativeThinSpace;': '\u200b', 'NegativeVeryThinSpace;': '\u200b', 'nequiv;': '≢', 'nesear;': '⤨', 'nesim;': '≂̸', 'NestedGreaterGreater;': '≫', 'NestedLessLess;': '≪', 'NewLine;': '\n', 'nexist;': '∄', 'nexists;': '∄', 'Nfr;': '𝔑', 'nfr;': '𝔫', 'ngE;': '≧̸', 'nge;': '≱', 'ngeq;': '≱', 'ngeqq;': '≧̸', 'ngeqslant;': '⩾̸', 'nges;': '⩾̸', 'nGg;': '⋙̸', 'ngsim;': '≵', 'nGt;': '≫⃒', 'ngt;': '≯', 'ngtr;': '≯', 'nGtv;': '≫̸', 'nhArr;': '⇎', 'nharr;': '↮', 'nhpar;': '⫲', 'ni;': '∋', 'nis;': '⋼', 'nisd;': '⋺', 'niv;': '∋', 'NJcy;': 'Њ', 'njcy;': 'њ', 'nlArr;': '⇍', 'nlarr;': '↚', 'nldr;': '‥', 'nlE;': '≦̸', 'nle;': '≰', 'nLeftarrow;': '⇍', 'nleftarrow;': '↚', 'nLeftrightarrow;': '⇎', 'nleftrightarrow;': '↮', 'nleq;': '≰', 'nleqq;': '≦̸', 'nleqslant;': '⩽̸', 'nles;': '⩽̸', 'nless;': '≮', 'nLl;': '⋘̸', 'nlsim;': '≴', 'nLt;': '≪⃒', 'nlt;': '≮', 'nltri;': '⋪', 'nltrie;': '⋬', 'nLtv;': '≪̸', 'nmid;': '∤', 'NoBreak;': '\u2060', 'NonBreakingSpace;': '\xa0', 'Nopf;': 'ℕ', 'nopf;': '𝕟', 'not': '¬', 'Not;': '⫬', 'not;': '¬', 'NotCongruent;': '≢', 'NotCupCap;': '≭', 'NotDoubleVerticalBar;': '∦', 'NotElement;': '∉', 'NotEqual;': '≠', 'NotEqualTilde;': '≂̸', 'NotExists;': '∄', 'NotGreater;': '≯', 'NotGreaterEqual;': '≱', 'NotGreaterFullEqual;': '≧̸', 'NotGreaterGreater;': '≫̸', 'NotGreaterLess;': '≹', 'NotGreaterSlantEqual;': '⩾̸', 'NotGreaterTilde;': '≵', 'NotHumpDownHump;': '≎̸', 'NotHumpEqual;': '≏̸', 'notin;': '∉', 'notindot;': '⋵̸', 'notinE;': '⋹̸', 'notinva;': '∉', 'notinvb;': '⋷', 'notinvc;': '⋶', 'NotLeftTriangle;': '⋪', 'NotLeftTriangleBar;': '⧏̸', 'NotLeftTriangleEqual;': '⋬', 'NotLess;': '≮', 'NotLessEqual;': '≰', 'NotLessGreater;': '≸', 'NotLessLess;': '≪̸', 'NotLessSlantEqual;': '⩽̸', 'NotLessTilde;': '≴', 'NotNestedGreaterGreater;': '⪢̸', 'NotNestedLessLess;': '⪡̸', 'notni;': '∌', 'notniva;': '∌', 'notnivb;': '⋾', 'notnivc;': '⋽', 'NotPrecedes;': '⊀', 'NotPrecedesEqual;': '⪯̸', 'NotPrecedesSlantEqual;': '⋠', 'NotReverseElement;': '∌', 'NotRightTriangle;': '⋫', 'NotRightTriangleBar;': '⧐̸', 'NotRightTriangleEqual;': '⋭', 'NotSquareSubset;': '⊏̸', 'NotSquareSubsetEqual;': '⋢', 'NotSquareSuperset;': '⊐̸', 'NotSquareSupersetEqual;': '⋣', 'NotSubset;': '⊂⃒', 'NotSubsetEqual;': '⊈', 'NotSucceeds;': '⊁', 'NotSucceedsEqual;': '⪰̸', 'NotSucceedsSlantEqual;': '⋡', 'NotSucceedsTilde;': '≿̸', 'NotSuperset;': '⊃⃒', 'NotSupersetEqual;': '⊉', 'NotTilde;': '≁', 'NotTildeEqual;': '≄', 'NotTildeFullEqual;': '≇', 'NotTildeTilde;': '≉', 'NotVerticalBar;': '∤', 'npar;': '∦', 'nparallel;': '∦', 'nparsl;': '⫽⃥', 'npart;': '∂̸', 'npolint;': '⨔', 'npr;': '⊀', 'nprcue;': '⋠', 'npre;': '⪯̸', 'nprec;': '⊀', 'npreceq;': '⪯̸', 'nrArr;': '⇏', 'nrarr;': '↛', 'nrarrc;': '⤳̸', 'nrarrw;': '↝̸', 'nRightarrow;': '⇏', 'nrightarrow;': '↛', 'nrtri;': '⋫', 'nrtrie;': '⋭', 'nsc;': '⊁', 'nsccue;': '⋡', 'nsce;': '⪰̸', 'Nscr;': '𝒩', 'nscr;': '𝓃', 'nshortmid;': '∤', 'nshortparallel;': '∦', 'nsim;': '≁', 'nsime;': '≄', 'nsimeq;': '≄', 'nsmid;': '∤', 'nspar;': '∦', 'nsqsube;': '⋢', 'nsqsupe;': '⋣', 'nsub;': '⊄', 'nsubE;': '⫅̸', 'nsube;': '⊈', 'nsubset;': '⊂⃒', 'nsubseteq;': '⊈', 'nsubseteqq;': '⫅̸', 'nsucc;': '⊁', 'nsucceq;': '⪰̸', 'nsup;': '⊅', 'nsupE;': '⫆̸', 'nsupe;': '⊉', 'nsupset;': '⊃⃒', 'nsupseteq;': '⊉', 'nsupseteqq;': '⫆̸', 'ntgl;': '≹', 'Ntilde': 'Ñ', 'ntilde': 'ñ', 'Ntilde;': 'Ñ', 'ntilde;': 'ñ', 'ntlg;': '≸', 'ntriangleleft;': '⋪', 'ntrianglelefteq;': '⋬', 'ntriangleright;': '⋫', 'ntrianglerighteq;': '⋭', 'Nu;': 'Ν', 'nu;': 'ν', 'num;': '#', 'numero;': '№', 'numsp;': '\u2007', 'nvap;': '≍⃒', 'nVDash;': '⊯', 'nVdash;': '⊮', 'nvDash;': '⊭', 'nvdash;': '⊬', 'nvge;': '≥⃒', 'nvgt;': '>⃒', 'nvHarr;': '⤄', 'nvinfin;': '⧞', 'nvlArr;': '⤂', 'nvle;': '≤⃒', 'nvlt;': '<⃒', 'nvltrie;': '⊴⃒', 'nvrArr;': '⤃', 'nvrtrie;': '⊵⃒', 'nvsim;': '∼⃒', 'nwarhk;': '⤣', 'nwArr;': '⇖', 'nwarr;': '↖', 'nwarrow;': '↖', 'nwnear;': '⤧', 'Oacute': 'Ó', 'oacute': 'ó', 'Oacute;': 'Ó', 'oacute;': 'ó', 'oast;': '⊛', 'ocir;': '⊚', 'Ocirc': 'Ô', 'ocirc': 'ô', 'Ocirc;': 'Ô', 'ocirc;': 'ô', 'Ocy;': 'О', 'ocy;': 'о', 'odash;': '⊝', 'Odblac;': 'Ő', 'odblac;': 'ő', 'odiv;': '⨸', 'odot;': '⊙', 'odsold;': '⦼', 'OElig;': 'Œ', 'oelig;': 'œ', 'ofcir;': '⦿', 'Ofr;': '𝔒', 'ofr;': '𝔬', 'ogon;': '˛', 'Ograve': 'Ò', 'ograve': 'ò', 'Ograve;': 'Ò', 'ograve;': 'ò', 'ogt;': '⧁', 'ohbar;': '⦵', 'ohm;': 'Ω', 'oint;': '∮', 'olarr;': '↺', 'olcir;': '⦾', 'olcross;': '⦻', 'oline;': '‾', 'olt;': '⧀', 'Omacr;': 'Ō', 'omacr;': 'ō', 'Omega;': 'Ω', 'omega;': 'ω', 'Omicron;': 'Ο', 'omicron;': 'ο', 'omid;': '⦶', 'ominus;': '⊖', 'Oopf;': '𝕆', 'oopf;': '𝕠', 'opar;': '⦷', 'OpenCurlyDoubleQuote;': '“', 'OpenCurlyQuote;': '‘', 'operp;': '⦹', 'oplus;': '⊕', 'Or;': '⩔', 'or;': '∨', 'orarr;': '↻', 'ord;': '⩝', 'order;': 'ℴ', 'orderof;': 'ℴ', 'ordf': 'ª', 'ordf;': 'ª', 'ordm': 'º', 'ordm;': 'º', 'origof;': '⊶', 'oror;': '⩖', 'orslope;': '⩗', 'orv;': '⩛', 'oS;': 'Ⓢ', 'Oscr;': '𝒪', 'oscr;': 'ℴ', 'Oslash': 'Ø', 'oslash': 'ø', 'Oslash;': 'Ø', 'oslash;': 'ø', 'osol;': '⊘', 'Otilde': 'Õ', 'otilde': 'õ', 'Otilde;': 'Õ', 'otilde;': 'õ', 'Otimes;': '⨷', 'otimes;': '⊗', 'otimesas;': '⨶', 'Ouml': 'Ö', 'ouml': 'ö', 'Ouml;': 'Ö', 'ouml;': 'ö', 'ovbar;': '⌽', 'OverBar;': '‾', 'OverBrace;': '⏞', 'OverBracket;': '⎴', 'OverParenthesis;': '⏜', 'par;': '∥', 'para': '¶', 'para;': '¶', 'parallel;': '∥', 'parsim;': '⫳', 'parsl;': '⫽', 'part;': '∂', 'PartialD;': '∂', 'Pcy;': 'П', 'pcy;': 'п', 'percnt;': '%', 'period;': '.', 'permil;': '‰', 'perp;': '⊥', 'pertenk;': '‱', 'Pfr;': '𝔓', 'pfr;': '𝔭', 'Phi;': 'Φ', 'phi;': 'φ', 'phiv;': 'ϕ', 'phmmat;': 'ℳ', 'phone;': '☎', 'Pi;': 'Π', 'pi;': 'π', 'pitchfork;': '⋔', 'piv;': 'ϖ', 'planck;': 'ℏ', 'planckh;': 'ℎ', 'plankv;': 'ℏ', 'plus;': '+', 'plusacir;': '⨣', 'plusb;': '⊞', 'pluscir;': '⨢', 'plusdo;': '∔', 'plusdu;': '⨥', 'pluse;': '⩲', 'PlusMinus;': '±', 'plusmn': '±', 'plusmn;': '±', 'plussim;': '⨦', 'plustwo;': '⨧', 'pm;': '±', 'Poincareplane;': 'ℌ', 'pointint;': '⨕', 'Popf;': 'ℙ', 'popf;': '𝕡', 'pound': '£', 'pound;': '£', 'Pr;': '⪻', 'pr;': '≺', 'prap;': '⪷', 'prcue;': '≼', 'prE;': '⪳', 'pre;': '⪯', 'prec;': '≺', 'precapprox;': '⪷', 'preccurlyeq;': '≼', 'Precedes;': '≺', 'PrecedesEqual;': '⪯', 'PrecedesSlantEqual;': '≼', 'PrecedesTilde;': '≾', 'preceq;': '⪯', 'precnapprox;': '⪹', 'precneqq;': '⪵', 'precnsim;': '⋨', 'precsim;': '≾', 'Prime;': '″', 'prime;': '′', 'primes;': 'ℙ', 'prnap;': '⪹', 'prnE;': '⪵', 'prnsim;': '⋨', 'prod;': '∏', 'Product;': '∏', 'profalar;': '⌮', 'profline;': '⌒', 'profsurf;': '⌓', 'prop;': '∝', 'Proportion;': '∷', 'Proportional;': '∝', 'propto;': '∝', 'prsim;': '≾', 'prurel;': '⊰', 'Pscr;': '𝒫', 'pscr;': '𝓅', 'Psi;': 'Ψ', 'psi;': 'ψ', 'puncsp;': '\u2008', 'Qfr;': '𝔔', 'qfr;': '𝔮', 'qint;': '⨌', 'Qopf;': 'ℚ', 'qopf;': '𝕢', 'qprime;': '⁗', 'Qscr;': '𝒬', 'qscr;': '𝓆', 'quaternions;': 'ℍ', 'quatint;': '⨖', 'quest;': '?', 'questeq;': '≟', 'QUOT': '"', 'quot': '"', 'QUOT;': '"', 'quot;': '"', 'rAarr;': '⇛', 'race;': '∽̱', 'Racute;': 'Ŕ', 'racute;': 'ŕ', 'radic;': '√', 'raemptyv;': '⦳', 'Rang;': '⟫', 'rang;': '⟩', 'rangd;': '⦒', 'range;': '⦥', 'rangle;': '⟩', 'raquo': '»', 'raquo;': '»', 'Rarr;': '↠', 'rArr;': '⇒', 'rarr;': '→', 'rarrap;': '⥵', 'rarrb;': '⇥', 'rarrbfs;': '⤠', 'rarrc;': '⤳', 'rarrfs;': '⤞', 'rarrhk;': '↪', 'rarrlp;': '↬', 'rarrpl;': '⥅', 'rarrsim;': '⥴', 'Rarrtl;': '⤖', 'rarrtl;': '↣', 'rarrw;': '↝', 'rAtail;': '⤜', 'ratail;': '⤚', 'ratio;': '∶', 'rationals;': 'ℚ', 'RBarr;': '⤐', 'rBarr;': '⤏', 'rbarr;': '⤍', 'rbbrk;': '❳', 'rbrace;': '}', 'rbrack;': ']', 'rbrke;': '⦌', 'rbrksld;': '⦎', 'rbrkslu;': '⦐', 'Rcaron;': 'Ř', 'rcaron;': 'ř', 'Rcedil;': 'Ŗ', 'rcedil;': 'ŗ', 'rceil;': '⌉', 'rcub;': '}', 'Rcy;': 'Р', 'rcy;': 'р', 'rdca;': '⤷', 'rdldhar;': '⥩', 'rdquo;': '”', 'rdquor;': '”', 'rdsh;': '↳', 'Re;': 'ℜ', 'real;': 'ℜ', 'realine;': 'ℛ', 'realpart;': 'ℜ', 'reals;': 'ℝ', 'rect;': '▭', 'REG': '®', 'reg': '®', 'REG;': '®', 'reg;': '®', 'ReverseElement;': '∋', 'ReverseEquilibrium;': '⇋', 'ReverseUpEquilibrium;': '⥯', 'rfisht;': '⥽', 'rfloor;': '⌋', 'Rfr;': 'ℜ', 'rfr;': '𝔯', 'rHar;': '⥤', 'rhard;': '⇁', 'rharu;': '⇀', 'rharul;': '⥬', 'Rho;': 'Ρ', 'rho;': 'ρ', 'rhov;': 'ϱ', 'RightAngleBracket;': '⟩', 'RightArrow;': '→', 'Rightarrow;': '⇒', 'rightarrow;': '→', 'RightArrowBar;': '⇥', 'RightArrowLeftArrow;': '⇄', 'rightarrowtail;': '↣', 'RightCeiling;': '⌉', 'RightDoubleBracket;': '⟧', 'RightDownTeeVector;': '⥝', 'RightDownVector;': '⇂', 'RightDownVectorBar;': '⥕', 'RightFloor;': '⌋', 'rightharpoondown;': '⇁', 'rightharpoonup;': '⇀', 'rightleftarrows;': '⇄', 'rightleftharpoons;': '⇌', 'rightrightarrows;': '⇉', 'rightsquigarrow;': '↝', 'RightTee;': '⊢', 'RightTeeArrow;': '↦', 'RightTeeVector;': '⥛', 'rightthreetimes;': '⋌', 'RightTriangle;': '⊳', 'RightTriangleBar;': '⧐', 'RightTriangleEqual;': '⊵', 'RightUpDownVector;': '⥏', 'RightUpTeeVector;': '⥜', 'RightUpVector;': '↾', 'RightUpVectorBar;': '⥔', 'RightVector;': '⇀', 'RightVectorBar;': '⥓', 'ring;': '˚', 'risingdotseq;': '≓', 'rlarr;': '⇄', 'rlhar;': '⇌', 'rlm;': '\u200f', 'rmoust;': '⎱', 'rmoustache;': '⎱', 'rnmid;': '⫮', 'roang;': '⟭', 'roarr;': '⇾', 'robrk;': '⟧', 'ropar;': '⦆', 'Ropf;': 'ℝ', 'ropf;': '𝕣', 'roplus;': '⨮', 'rotimes;': '⨵', 'RoundImplies;': '⥰', 'rpar;': ')', 'rpargt;': '⦔', 'rppolint;': '⨒', 'rrarr;': '⇉', 'Rrightarrow;': '⇛', 'rsaquo;': '›', 'Rscr;': 'ℛ', 'rscr;': '𝓇', 'Rsh;': '↱', 'rsh;': '↱', 'rsqb;': ']', 'rsquo;': '’', 'rsquor;': '’', 'rthree;': '⋌', 'rtimes;': '⋊', 'rtri;': '▹', 'rtrie;': '⊵', 'rtrif;': '▸', 'rtriltri;': '⧎', 'RuleDelayed;': '⧴', 'ruluhar;': '⥨', 'rx;': '℞', 'Sacute;': 'Ś', 'sacute;': 'ś', 'sbquo;': '‚', 'Sc;': '⪼', 'sc;': '≻', 'scap;': '⪸', 'Scaron;': 'Š', 'scaron;': 'š', 'sccue;': '≽', 'scE;': '⪴', 'sce;': '⪰', 'Scedil;': 'Ş', 'scedil;': 'ş', 'Scirc;': 'Ŝ', 'scirc;': 'ŝ', 'scnap;': '⪺', 'scnE;': '⪶', 'scnsim;': '⋩', 'scpolint;': '⨓', 'scsim;': '≿', 'Scy;': 'С', 'scy;': 'с', 'sdot;': '⋅', 'sdotb;': '⊡', 'sdote;': '⩦', 'searhk;': '⤥', 'seArr;': '⇘', 'searr;': '↘', 'searrow;': '↘', 'sect': '§', 'sect;': '§', 'semi;': ';', 'seswar;': '⤩', 'setminus;': '∖', 'setmn;': '∖', 'sext;': '✶', 'Sfr;': '𝔖', 'sfr;': '𝔰', 'sfrown;': '⌢', 'sharp;': '♯', 'SHCHcy;': 'Щ', 'shchcy;': 'щ', 'SHcy;': 'Ш', 'shcy;': 'ш', 'ShortDownArrow;': '↓', 'ShortLeftArrow;': '←', 'shortmid;': '∣', 'shortparallel;': '∥', 'ShortRightArrow;': '→', 'ShortUpArrow;': '↑', 'shy': '\xad', 'shy;': '\xad', 'Sigma;': 'Σ', 'sigma;': 'σ', 'sigmaf;': 'ς', 'sigmav;': 'ς', 'sim;': '∼', 'simdot;': '⩪', 'sime;': '≃', 'simeq;': '≃', 'simg;': '⪞', 'simgE;': '⪠', 'siml;': '⪝', 'simlE;': '⪟', 'simne;': '≆', 'simplus;': '⨤', 'simrarr;': '⥲', 'slarr;': '←', 'SmallCircle;': '∘', 'smallsetminus;': '∖', 'smashp;': '⨳', 'smeparsl;': '⧤', 'smid;': '∣', 'smile;': '⌣', 'smt;': '⪪', 'smte;': '⪬', 'smtes;': '⪬︀', 'SOFTcy;': 'Ь', 'softcy;': 'ь', 'sol;': '/', 'solb;': '⧄', 'solbar;': '⌿', 'Sopf;': '𝕊', 'sopf;': '𝕤', 'spades;': '♠', 'spadesuit;': '♠', 'spar;': '∥', 'sqcap;': '⊓', 'sqcaps;': '⊓︀', 'sqcup;': '⊔', 'sqcups;': '⊔︀', 'Sqrt;': '√', 'sqsub;': '⊏', 'sqsube;': '⊑', 'sqsubset;': '⊏', 'sqsubseteq;': '⊑', 'sqsup;': '⊐', 'sqsupe;': '⊒', 'sqsupset;': '⊐', 'sqsupseteq;': '⊒', 'squ;': '□', 'Square;': '□', 'square;': '□', 'SquareIntersection;': '⊓', 'SquareSubset;': '⊏', 'SquareSubsetEqual;': '⊑', 'SquareSuperset;': '⊐', 'SquareSupersetEqual;': '⊒', 'SquareUnion;': '⊔', 'squarf;': '▪', 'squf;': '▪', 'srarr;': '→', 'Sscr;': '𝒮', 'sscr;': '𝓈', 'ssetmn;': '∖', 'ssmile;': '⌣', 'sstarf;': '⋆', 'Star;': '⋆', 'star;': '☆', 'starf;': '★', 'straightepsilon;': 'ϵ', 'straightphi;': 'ϕ', 'strns;': '¯', 'Sub;': '⋐', 'sub;': '⊂', 'subdot;': '⪽', 'subE;': '⫅', 'sube;': '⊆', 'subedot;': '⫃', 'submult;': '⫁', 'subnE;': '⫋', 'subne;': '⊊', 'subplus;': '⪿', 'subrarr;': '⥹', 'Subset;': '⋐', 'subset;': '⊂', 'subseteq;': '⊆', 'subseteqq;': '⫅', 'SubsetEqual;': '⊆', 'subsetneq;': '⊊', 'subsetneqq;': '⫋', 'subsim;': '⫇', 'subsub;': '⫕', 'subsup;': '⫓', 'succ;': '≻', 'succapprox;': '⪸', 'succcurlyeq;': '≽', 'Succeeds;': '≻', 'SucceedsEqual;': '⪰', 'SucceedsSlantEqual;': '≽', 'SucceedsTilde;': '≿', 'succeq;': '⪰', 'succnapprox;': '⪺', 'succneqq;': '⪶', 'succnsim;': '⋩', 'succsim;': '≿', 'SuchThat;': '∋', 'Sum;': '∑', 'sum;': '∑', 'sung;': '♪', 'sup1': '¹', 'sup1;': '¹', 'sup2': '²', 'sup2;': '²', 'sup3': '³', 'sup3;': '³', 'Sup;': '⋑', 'sup;': '⊃', 'supdot;': '⪾', 'supdsub;': '⫘', 'supE;': '⫆', 'supe;': '⊇', 'supedot;': '⫄', 'Superset;': '⊃', 'SupersetEqual;': '⊇', 'suphsol;': '⟉', 'suphsub;': '⫗', 'suplarr;': '⥻', 'supmult;': '⫂', 'supnE;': '⫌', 'supne;': '⊋', 'supplus;': '⫀', 'Supset;': '⋑', 'supset;': '⊃', 'supseteq;': '⊇', 'supseteqq;': '⫆', 'supsetneq;': '⊋', 'supsetneqq;': '⫌', 'supsim;': '⫈', 'supsub;': '⫔', 'supsup;': '⫖', 'swarhk;': '⤦', 'swArr;': '⇙', 'swarr;': '↙', 'swarrow;': '↙', 'swnwar;': '⤪', 'szlig': 'ß', 'szlig;': 'ß', 'Tab;': '\t', 'target;': '⌖', 'Tau;': 'Τ', 'tau;': 'τ', 'tbrk;': '⎴', 'Tcaron;': 'Ť', 'tcaron;': 'ť', 'Tcedil;': 'Ţ', 'tcedil;': 'ţ', 'Tcy;': 'Т', 'tcy;': 'т', 'tdot;': '⃛', 'telrec;': '⌕', 'Tfr;': '𝔗', 'tfr;': '𝔱', 'there4;': '∴', 'Therefore;': '∴', 'therefore;': '∴', 'Theta;': 'Θ', 'theta;': 'θ', 'thetasym;': 'ϑ', 'thetav;': 'ϑ', 'thickapprox;': '≈', 'thicksim;': '∼', 'ThickSpace;': '\u205f\u200a', 'thinsp;': '\u2009', 'ThinSpace;': '\u2009', 'thkap;': '≈', 'thksim;': '∼', 'THORN': 'Þ', 'thorn': 'þ', 'THORN;': 'Þ', 'thorn;': 'þ', 'Tilde;': '∼', 'tilde;': '˜', 'TildeEqual;': '≃', 'TildeFullEqual;': '≅', 'TildeTilde;': '≈', 'times': '×', 'times;': '×', 'timesb;': '⊠', 'timesbar;': '⨱', 'timesd;': '⨰', 'tint;': '∭', 'toea;': '⤨', 'top;': '⊤', 'topbot;': '⌶', 'topcir;': '⫱', 'Topf;': '𝕋', 'topf;': '𝕥', 'topfork;': '⫚', 'tosa;': '⤩', 'tprime;': '‴', 'TRADE;': '™', 'trade;': '™', 'triangle;': '▵', 'triangledown;': '▿', 'triangleleft;': '◃', 'trianglelefteq;': '⊴', 'triangleq;': '≜', 'triangleright;': '▹', 'trianglerighteq;': '⊵', 'tridot;': '◬', 'trie;': '≜', 'triminus;': '⨺', 'TripleDot;': '⃛', 'triplus;': '⨹', 'trisb;': '⧍', 'tritime;': '⨻', 'trpezium;': '⏢', 'Tscr;': '𝒯', 'tscr;': '𝓉', 'TScy;': 'Ц', 'tscy;': 'ц', 'TSHcy;': 'Ћ', 'tshcy;': 'ћ', 'Tstrok;': 'Ŧ', 'tstrok;': 'ŧ', 'twixt;': '≬', 'twoheadleftarrow;': '↞', 'twoheadrightarrow;': '↠', 'Uacute': 'Ú', 'uacute': 'ú', 'Uacute;': 'Ú', 'uacute;': 'ú', 'Uarr;': '↟', 'uArr;': '⇑', 'uarr;': '↑', 'Uarrocir;': '⥉', 'Ubrcy;': 'Ў', 'ubrcy;': 'ў', 'Ubreve;': 'Ŭ', 'ubreve;': 'ŭ', 'Ucirc': 'Û', 'ucirc': 'û', 'Ucirc;': 'Û', 'ucirc;': 'û', 'Ucy;': 'У', 'ucy;': 'у', 'udarr;': '⇅', 'Udblac;': 'Ű', 'udblac;': 'ű', 'udhar;': '⥮', 'ufisht;': '⥾', 'Ufr;': '𝔘', 'ufr;': '𝔲', 'Ugrave': 'Ù', 'ugrave': 'ù', 'Ugrave;': 'Ù', 'ugrave;': 'ù', 'uHar;': '⥣', 'uharl;': '↿', 'uharr;': '↾', 'uhblk;': '▀', 'ulcorn;': '⌜', 'ulcorner;': '⌜', 'ulcrop;': '⌏', 'ultri;': '◸', 'Umacr;': 'Ū', 'umacr;': 'ū', 'uml': '¨', 'uml;': '¨', 'UnderBar;': '_', 'UnderBrace;': '⏟', 'UnderBracket;': '⎵', 'UnderParenthesis;': '⏝', 'Union;': '⋃', 'UnionPlus;': '⊎', 'Uogon;': 'Ų', 'uogon;': 'ų', 'Uopf;': '𝕌', 'uopf;': '𝕦', 'UpArrow;': '↑', 'Uparrow;': '⇑', 'uparrow;': '↑', 'UpArrowBar;': '⤒', 'UpArrowDownArrow;': '⇅', 'UpDownArrow;': '↕', 'Updownarrow;': '⇕', 'updownarrow;': '↕', 'UpEquilibrium;': '⥮', 'upharpoonleft;': '↿', 'upharpoonright;': '↾', 'uplus;': '⊎', 'UpperLeftArrow;': '↖', 'UpperRightArrow;': '↗', 'Upsi;': 'ϒ', 'upsi;': 'υ', 'upsih;': 'ϒ', 'Upsilon;': 'Υ', 'upsilon;': 'υ', 'UpTee;': '⊥', 'UpTeeArrow;': '↥', 'upuparrows;': '⇈', 'urcorn;': '⌝', 'urcorner;': '⌝', 'urcrop;': '⌎', 'Uring;': 'Ů', 'uring;': 'ů', 'urtri;': '◹', 'Uscr;': '𝒰', 'uscr;': '𝓊', 'utdot;': '⋰', 'Utilde;': 'Ũ', 'utilde;': 'ũ', 'utri;': '▵', 'utrif;': '▴', 'uuarr;': '⇈', 'Uuml': 'Ü', 'uuml': 'ü', 'Uuml;': 'Ü', 'uuml;': 'ü', 'uwangle;': '⦧', 'vangrt;': '⦜', 'varepsilon;': 'ϵ', 'varkappa;': 'ϰ', 'varnothing;': '∅', 'varphi;': 'ϕ', 'varpi;': 'ϖ', 'varpropto;': '∝', 'vArr;': '⇕', 'varr;': '↕', 'varrho;': 'ϱ', 'varsigma;': 'ς', 'varsubsetneq;': '⊊︀', 'varsubsetneqq;': '⫋︀', 'varsupsetneq;': '⊋︀', 'varsupsetneqq;': '⫌︀', 'vartheta;': 'ϑ', 'vartriangleleft;': '⊲', 'vartriangleright;': '⊳', 'Vbar;': '⫫', 'vBar;': '⫨', 'vBarv;': '⫩', 'Vcy;': 'В', 'vcy;': 'в', 'VDash;': '⊫', 'Vdash;': '⊩', 'vDash;': '⊨', 'vdash;': '⊢', 'Vdashl;': '⫦', 'Vee;': '⋁', 'vee;': '∨', 'veebar;': '⊻', 'veeeq;': '≚', 'vellip;': '⋮', 'Verbar;': '‖', 'verbar;': '|', 'Vert;': '‖', 'vert;': '|', 'VerticalBar;': '∣', 'VerticalLine;': '|', 'VerticalSeparator;': '❘', 'VerticalTilde;': '≀', 'VeryThinSpace;': '\u200a', 'Vfr;': '𝔙', 'vfr;': '𝔳', 'vltri;': '⊲', 'vnsub;': '⊂⃒', 'vnsup;': '⊃⃒', 'Vopf;': '𝕍', 'vopf;': '𝕧', 'vprop;': '∝', 'vrtri;': '⊳', 'Vscr;': '𝒱', 'vscr;': '𝓋', 'vsubnE;': '⫋︀', 'vsubne;': '⊊︀', 'vsupnE;': '⫌︀', 'vsupne;': '⊋︀', 'Vvdash;': '⊪', 'vzigzag;': '⦚', 'Wcirc;': 'Ŵ', 'wcirc;': 'ŵ', 'wedbar;': '⩟', 'Wedge;': '⋀', 'wedge;': '∧', 'wedgeq;': '≙', 'weierp;': '℘', 'Wfr;': '𝔚', 'wfr;': '𝔴', 'Wopf;': '𝕎', 'wopf;': '𝕨', 'wp;': '℘', 'wr;': '≀', 'wreath;': '≀', 'Wscr;': '𝒲', 'wscr;': '𝓌', 'xcap;': '⋂', 'xcirc;': '◯', 'xcup;': '⋃', 'xdtri;': '▽', 'Xfr;': '𝔛', 'xfr;': '𝔵', 'xhArr;': '⟺', 'xharr;': '⟷', 'Xi;': 'Ξ', 'xi;': 'ξ', 'xlArr;': '⟸', 'xlarr;': '⟵', 'xmap;': '⟼', 'xnis;': '⋻', 'xodot;': '⨀', 'Xopf;': '𝕏', 'xopf;': '𝕩', 'xoplus;': '⨁', 'xotime;': '⨂', 'xrArr;': '⟹', 'xrarr;': '⟶', 'Xscr;': '𝒳', 'xscr;': '𝓍', 'xsqcup;': '⨆', 'xuplus;': '⨄', 'xutri;': '△', 'xvee;': '⋁', 'xwedge;': '⋀', 'Yacute': 'Ý', 'yacute': 'ý', 'Yacute;': 'Ý', 'yacute;': 'ý', 'YAcy;': 'Я', 'yacy;': 'я', 'Ycirc;': 'Ŷ', 'ycirc;': 'ŷ', 'Ycy;': 'Ы', 'ycy;': 'ы', 'yen': '¥', 'yen;': '¥', 'Yfr;': '𝔜', 'yfr;': '𝔶', 'YIcy;': 'Ї', 'yicy;': 'ї', 'Yopf;': '𝕐', 'yopf;': '𝕪', 'Yscr;': '𝒴', 'yscr;': '𝓎', 'YUcy;': 'Ю', 'yucy;': 'ю', 'yuml': 'ÿ', 'Yuml;': 'Ÿ', 'yuml;': 'ÿ', 'Zacute;': 'Ź', 'zacute;': 'ź', 'Zcaron;': 'Ž', 'zcaron;': 'ž', 'Zcy;': 'З', 'zcy;': 'з', 'Zdot;': 'Ż', 'zdot;': 'ż', 'zeetrf;': 'ℨ', 'ZeroWidthSpace;': '\u200b', 'Zeta;': 'Ζ', 'zeta;': 'ζ', 'Zfr;': 'ℨ', 'zfr;': '𝔷', 'ZHcy;': 'Ж', 'zhcy;': 'ж', 'zigrarr;': '⇝', 'Zopf;': 'ℤ', 'zopf;': '𝕫', 'Zscr;': '𝒵', 'zscr;': '𝓏', 'zwj;': '\u200d', 'zwnj;': '\u200c'}
codepoint2name = {}
entitydefs = {}
for (name, codepoint) in name2codepoint.items():
    codepoint2name[codepoint] = name
    entitydefs[name] = chr(codepoint)
del name
del codepoint
